/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationFactory {
    public static Properties parseAppXml(File file) throws Exception {
        FileInputStream in = new FileInputStream(file);
        return ConfigurationFactory.parseAppXml(in);
    }

    public static Properties parseAppXml(InputStream in) throws Exception {
        Node errPageNode;
        NodeList errPageNodes;
        Node sessionNode;
        NodeList sessionNodes;
        Node indexFileNode;
        NodeList indexFileNodes;
        Node staticRuleNode;
        NodeList staticRuleNodes;
        Node rootNode;
        NodeList rootNodes;
        Node serverNode;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuiler = dbFactory.newDocumentBuilder();
        Document doc = dBuiler.parse(in);
        doc.getDocumentElement().normalize();
        Properties properties = new Properties();
        NodeList serverNodes = doc.getElementsByTagName("server");
        if (serverNodes.getLength() > 0 && (serverNode = serverNodes.item(0)).getNodeType() == 1) {
            Element element = (Element)serverNode;
            properties.put("razor.server.host", element.getElementsByTagName("host").item(0).getTextContent());
            properties.put("razor.server.port", (Object)Integer.parseInt(element.getElementsByTagName("port").item(0).getTextContent()));
            properties.put("razor.server.charset", element.getElementsByTagName("charset").item(0).getTextContent());
            properties.put("razor.web.http.cache.seconds", (Object)Integer.parseInt(element.getElementsByTagName("cache").item(0).getTextContent()));
            properties.put("razor.server.ssl", (Object)"true".equals(element.getElementsByTagName("ssl").item(0).getTextContent()));
        }
        if ((rootNodes = doc.getElementsByTagName("root")).getLength() > 0 && (rootNode = rootNodes.item(0)).getNodeType() == 1) {
            Element element = (Element)rootNode;
            NodeList props = element.getElementsByTagName("property");
            block20: for (int i = 0; i < props.getLength(); ++i) {
                String name;
                Element propEle = (Element)props.item(i);
                switch (name = propEle.getAttribute("name")) {
                    case "www": {
                        String webRoot = propEle.getTextContent();
                        boolean useOuterWebRoot = webRoot.startsWith("/") || Pattern.compile("^([a-zA-Z]):".concat(File.separator + File.separator)).matcher(webRoot).find();
                        properties.put("razor.web.root", propEle.getTextContent());
                        properties.put("razor.web.root.outer", (Object)useOuterWebRoot);
                        continue block20;
                    }
                    case "template": {
                        properties.put("razor.web.template.root", propEle.getTextContent());
                    }
                }
            }
        }
        if ((staticRuleNodes = doc.getElementsByTagName("statics")).getLength() > 0 && (staticRuleNode = staticRuleNodes.item(0)).getNodeType() == 1) {
            Element element = (Element)staticRuleNode;
            NodeList indexs = element.getElementsByTagName("static");
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < indexs.getLength(); ++i) {
                list.add(indexs.item(i).getTextContent());
            }
            properties.put("razor.web.statics", list);
        }
        if ((indexFileNodes = doc.getElementsByTagName("indexFiles")).getLength() > 0 && (indexFileNode = indexFileNodes.item(0)).getNodeType() == 1) {
            Element element = (Element)indexFileNode;
            NodeList indexs = element.getElementsByTagName("index");
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < indexs.getLength(); ++i) {
                list.add(indexs.item(i).getTextContent());
            }
            properties.put("razor.web.indexs", list);
        }
        if ((sessionNodes = doc.getElementsByTagName("session")).getLength() > 0 && (sessionNode = sessionNodes.item(0)).getNodeType() == 1) {
            Element element = (Element)sessionNode;
            properties.put("razor.web.http.session.key", element.getElementsByTagName("key").item(0).getTextContent());
            properties.put("razor.web.http.session.timeout", (Object)Integer.parseInt(element.getElementsByTagName("timeout").item(0).getTextContent()));
        }
        if ((errPageNodes = doc.getElementsByTagName("errorPage")).getLength() > 0 && (errPageNode = errPageNodes.item(0)).getNodeType() == 1) {
            Element element = (Element)errPageNode;
            NodeList props = element.getElementsByTagName("property");
            block23: for (int i = 0; i < props.getLength(); ++i) {
                String name;
                Element propEle = (Element)props.item(i);
                switch (name = propEle.getAttribute("name")) {
                    case "403": {
                        properties.put("razor.web.template.403", propEle.getTextContent());
                        continue block23;
                    }
                    case "404": {
                        properties.put("razor.web.template.404", propEle.getTextContent());
                        continue block23;
                    }
                    case "500": {
                        properties.put("razor.web.template.500", propEle.getTextContent());
                        continue block23;
                    }
                    case "502": {
                        properties.put("razor.web.template.502", propEle.getTextContent());
                    }
                }
            }
        }
        return properties;
    }
}

