/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.env;

import com.fedepot.config.ConfigurationFactory;
import com.fedepot.mvc.Constants;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Env {
    private static final Logger log = LoggerFactory.getLogger(Env.class);
    private Properties props = new Properties();

    private Env(Properties props) {
        this.props = props;
    }

    public static Env defaults() {
        return new Env();
    }

    public Env set(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.props.put(key, value);
        return this;
    }

    public Env setMulti(@NonNull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        map.forEach(this.props::setProperty);
        return this;
    }

    public Optional<String> get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return Optional.ofNullable(this.props.getProperty(key));
    }

    public String get(@NonNull String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.props.getProperty(key, defaultValue);
    }

    public Optional<Object> getObject(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return Optional.ofNullable(this.props.get(key));
    }

    public Optional<Integer> getInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Optional<Object> optional = this.getObject(key);
        return optional.isPresent() ? Optional.of(Integer.parseInt(optional.get().toString())) : Optional.empty();
    }

    public Integer getInt(@NonNull String key, int defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.getInt(key).orElse(defaultValue);
    }

    public Optional<Long> getLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Optional<Object> optional = this.getObject(key);
        return optional.isPresent() ? Optional.of(Long.parseLong(optional.get().toString())) : Optional.empty();
    }

    public Long getLong(@NonNull String key, long defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.getLong(key).orElse(defaultValue);
    }

    public Optional<Double> getDouble(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Optional<Object> optional = this.getObject(key);
        return optional.isPresent() ? Optional.of(Double.parseDouble(optional.get().toString())) : Optional.empty();
    }

    public Double getDouble(@NonNull String key, double defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.getDouble(key).orElse(defaultValue);
    }

    public Optional<Boolean> getBool(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Optional<Object> optional = this.getObject(key);
        return optional.isPresent() ? Optional.of(Boolean.parseBoolean(optional.get().toString())) : Optional.empty();
    }

    public Boolean getBool(@NonNull String key, boolean defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.getBool(key).orElse(defaultValue);
    }

    public Properties getProps() {
        return this.props;
    }

    public static Env fromXml() {
        String appXmlPath = Constants.APP_CLASS_PATH.concat("/WEB-INF/app.xml");
        URL appXmlUrl = Env.class.getResource("/WEB-INF/app.xml");
        try {
            Properties properties;
            if (appXmlUrl == null) {
                String defaultAppXmlPath = Constants.RAZOR_CLASS_PATH.concat("app_default.xml");
                log.info("App configuration file {} is not exist, use {} instead.", (Object)appXmlPath, (Object)defaultAppXmlPath);
                properties = ConfigurationFactory.parseAppXml(Env.class.getResourceAsStream("/app_default.xml"));
            } else {
                log.info("App use configuration from file {}", (Object)appXmlPath);
                properties = ConfigurationFactory.parseAppXml(appXmlUrl.openStream());
            }
            return new Env(properties);
        }
        catch (Exception e) {
            log.error(e.toString());
            return Env.defaults();
        }
    }

    private Env() {
    }
}

