/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.event;

import com.fedepot.Razor;
import com.fedepot.event.Event;
import com.fedepot.event.EventListener;
import com.fedepot.event.EventType;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class EventEmitter {
    private static EventEmitter instance;
    private Map<EventType, List<EventListener>> listeners = Stream.of(EventType.values()).collect(Collectors.toMap(key -> key, value -> new LinkedList()));

    private EventEmitter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventEmitter newInstance() {
        if (instance != null) return instance;
        Class<EventEmitter> clazz = EventEmitter.class;
        synchronized (EventEmitter.class) {
            if (instance != null) return instance;
            instance = new EventEmitter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void on(EventType eventType, EventListener listener) {
        this.listeners.get((Object)eventType).add(listener);
    }

    public void emit(EventType eventType) {
        this.emit(eventType, null);
    }

    public void emit(EventType eventType, Razor razor) {
        this.listeners.get((Object)eventType).forEach(listener -> listener.call(new Event(eventType, razor)));
    }
}

