/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.ioc;

import com.fedepot.ioc.IContainer;
import com.fedepot.ioc.IContainerBuilder;
import com.fedepot.ioc.IRegistrationBuilder;
import com.fedepot.ioc.Ioc;
import com.fedepot.ioc.RegistrationBuilder;
import com.fedepot.ioc.ServiceBean;
import com.fedepot.ioc.annotation.IocIgnore;
import com.fedepot.ioc.annotation.Service;
import com.fedepot.ioc.exception.DependencyRegisterException;
import com.fedepot.ioc.walker.ClassesWalker;
import com.fedepot.ioc.walker.ConstructorWalker;
import com.fedepot.ioc.walker.FieldsWalker;
import com.fedepot.mvc.controller.APIController;
import com.fedepot.mvc.controller.Controller;
import com.fedepot.util.ReflectKit;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerBuilder
implements IContainerBuilder {
    private static final Logger log = LoggerFactory.getLogger(ContainerBuilder.class);
    private static ContainerBuilder instance;
    private Class<?> appClass;
    private final List<RegistrationBuilder> rbs = new ArrayList<RegistrationBuilder>();
    private final Set<Class<?>> registeredTypes = new HashSet();

    private ContainerBuilder(Class<?> appClass) {
        this.appClass = appClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContainerBuilder getInstance(Class<?> appClass) {
        if (instance != null) return instance;
        Class<ContainerBuilder> clazz = ContainerBuilder.class;
        synchronized (ContainerBuilder.class) {
            if (instance != null) return instance;
            instance = new ContainerBuilder(appClass);
            instance.autoRegister();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void autoRegister() {
        Reflections reflections = ReflectKit.getReflections(this.appClass);
        Set types = reflections.getTypesAnnotatedWith(Service.class);
        types.forEach(this::recursiveRegisterType);
        types.forEach(t -> {
            try {
                ConstructorWalker.findInjectConstructor(t);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        });
    }

    @Override
    public <T> IRegistrationBuilder registerType(Class<T> implementer) throws DependencyRegisterException {
        if (implementer.isInterface()) {
            throw new DependencyRegisterException("Should not register a interface directly");
        }
        RegistrationBuilder rb = RegistrationBuilder.forType(implementer);
        this.rbs.add(rb);
        return rb;
    }

    @Override
    public <T> IRegistrationBuilder registerInstance(T instance) {
        RegistrationBuilder rb = RegistrationBuilder.forInstance(instance);
        this.rbs.add(rb);
        return rb;
    }

    @Override
    public <T> void autoRegister(Class<T> clazz) {
        IocIgnore ignore = clazz.getAnnotation(IocIgnore.class);
        if (ignore != null) {
            return;
        }
        if (clazz.isInterface()) {
            this.recursiveRegisterType(clazz);
            return;
        }
        if (clazz == Controller.class || clazz == APIController.class) {
            this.registerControllers(clazz);
        }
    }

    private <T> void registerControllers(Class<T> abstractController) {
        Reflections reflections = ReflectKit.getReflections(this.appClass);
        Set controllers = reflections.getSubTypesOf(abstractController);
        controllers.forEach(this::recursiveRegisterType);
        log.info("Ioc registered {} controllers", (Object)controllers.size());
    }

    private void recursiveRegisterType(Class<?> clazz) {
        if (this.registeredTypes.contains(clazz)) {
            return;
        }
        IocIgnore ignore = clazz.getAnnotation(IocIgnore.class);
        if (ignore != null) {
            return;
        }
        this.registeredTypes.add(clazz);
        if (clazz.isInterface()) {
            Class<?>[] implementers = ClassesWalker.reflectImplementers(this.appClass, clazz);
            Arrays.stream(implementers).forEach(this::recursiveRegisterType);
            return;
        }
        try {
            Service inject = clazz.getAnnotation(Service.class);
            if (inject != null && inject.sington()) {
                this.registerType(clazz).singleInstance();
            } else {
                this.registerType(clazz).instancePerDependency();
            }
            Constructor constructor = ConstructorWalker.findInjectConstructor(clazz);
            if (constructor != null) {
                Parameter[] paramNames = constructor.getParameters();
                Arrays.stream(paramNames).map(Parameter::getType).forEach(this::recursiveRegisterType);
                log.info("Ioc registered {} parameters for {} constructor", (Object)paramNames, (Object)clazz.getName());
                this.registerFields(clazz);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private void registerFields(Class<?> clazz) throws DependencyRegisterException {
        try {
            Field[] serviceFields = FieldsWalker.findInjectFields(clazz);
            Arrays.stream(serviceFields).map(Field::getType).forEach(this::recursiveRegisterType);
            log.info("Ioc registered {} fields for controller {}", (Object)serviceFields.length, (Object)clazz.getName());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public IContainer build() {
        Ioc ioc = new Ioc(this.rbs.stream().map(t -> ServiceBean.fromRegistrationData(t.getRegistrationData())).collect(Collectors.toList()));
        this.rbs.clear();
        this.registeredTypes.clear();
        return ioc;
    }
}

