/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.ioc;

import com.fedepot.ioc.IContainer;
import com.fedepot.ioc.ServiceBean;
import com.fedepot.ioc.exception.DependencyResolveException;
import com.fedepot.ioc.walker.ClassesWalker;
import com.fedepot.ioc.walker.ConstructorWalker;
import com.fedepot.ioc.walker.FieldsWalker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ioc
implements IContainer {
    private static final Logger log = LoggerFactory.getLogger(Ioc.class);
    private final Map<String, ServiceBean> beanPool = new HashMap<String, ServiceBean>();
    private final Map<String, ServiceBean> namedBeanPool = new HashMap<String, ServiceBean>();
    private final Map<String, Map<Object, ServiceBean>> keyedBeanPool = new HashMap<String, Map<Object, ServiceBean>>();

    Ioc(List<ServiceBean> beans) {
        for (ServiceBean bean : beans) {
            String typeName = bean.getRegType().getName();
            if (bean.hasKey()) {
                Map<Object, ServiceBean> innerMap = this.keyedBeanPool.get(typeName);
                if (innerMap == null) {
                    innerMap = new HashMap<Object, ServiceBean>();
                }
                innerMap.put(bean.getKey(), bean);
                this.keyedBeanPool.put(typeName, innerMap);
            }
            if (bean.hasName()) {
                this.namedBeanPool.put(typeName.concat("-").concat(bean.getName()), bean);
            }
            this.beanPool.put(typeName, bean);
        }
    }

    @Override
    public <T> T resolve(Class<T> t) {
        if (t.isInterface()) {
            Class<?>[] implementers = ClassesWalker.cachedImplementers(t);
            if (implementers.length == 0) {
                return null;
            }
            for (Class<?> implementer : implementers) {
                Class<?> ret = this.resolve((T)implementer);
                if (ret == null) continue;
                return (T)ret;
            }
            return null;
        }
        try {
            return this.resolveBean(this.beanPool.get(t.getName()));
        }
        catch (DependencyResolveException e) {
            log.error("Resolve {} encounter exception: {}", (Object)t.getName(), (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public <T> T resolve(T t) {
        Field[] fields = FieldsWalker.cachedInjectFields(t.getClass());
        Arrays.stream(fields).forEach(field -> {
            boolean accessible = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(t, this.resolve((Object)field.getType()));
            }
            catch (IllegalAccessException e) {
                log.error("Access field {} of {} with exception: {}", new Object[]{field.getName(), t.getClass().getName(), e.getMessage()});
            }
            finally {
                field.setAccessible(accessible);
            }
        });
        return t;
    }

    @Override
    public <T> T resolveNamed(Class<T> t, String name) {
        if (t.isInterface()) {
            Class<?>[] implementers = ClassesWalker.cachedImplementers(t);
            if (implementers.length == 0) {
                return null;
            }
            for (Class<?> implementer : implementers) {
                Object ret = this.resolveNamed(implementer, name);
                if (ret == null) continue;
                return (T)ret;
            }
            return null;
        }
        try {
            return this.resolveBean(this.namedBeanPool.get(t.getName().concat("-").concat(name)));
        }
        catch (DependencyResolveException e) {
            log.error("Resolve {} named {} encounter exception: {}", new Object[]{t.getName(), name, e.getMessage()});
            return null;
        }
    }

    @Override
    public <T, E extends Enum<E>> T resolveKeyed(Class<T> t, E enumKey) {
        if (t.isInterface()) {
            Class<?>[] implementers = ClassesWalker.cachedImplementers(t);
            if (implementers.length == 0) {
                return null;
            }
            for (Class<?> implementer : implementers) {
                Object ret = this.resolveKeyed(implementer, enumKey);
                if (ret == null) continue;
                return (T)ret;
            }
            return null;
        }
        try {
            Map<Object, ServiceBean> svbMap = this.keyedBeanPool.get(t.getName());
            return this.resolveBean(svbMap.get(enumKey));
        }
        catch (DependencyResolveException e) {
            log.error("Resolve {} keyed {} encounter exception: {}", new Object[]{t.getName(), enumKey.toString(), e.getMessage()});
            return null;
        }
    }

    private <T> T resolveBean(ServiceBean svb) throws DependencyResolveException {
        if (svb == null) {
            return null;
        }
        Object bean = svb.getBean();
        if (bean != null) {
            return (T)bean;
        }
        try {
            Object ins;
            Class<?> clazz = svb.getImplType();
            if (clazz.isInterface()) {
                Class<?>[] implementers;
                for (Class<?> implementer : implementers = ClassesWalker.cachedImplementers(clazz)) {
                    Class<?> ret = this.resolve((T)implementer);
                    if (ret == null) continue;
                    return (T)ret;
                }
                throw new DependencyResolveException("Cannot resolve interface " + clazz.getName());
            }
            Constructor constructor = ConstructorWalker.cachedInjectConstructor(clazz);
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length == 0) {
                ins = constructor.newInstance(new Object[0]);
            } else {
                Object[] args = Arrays.stream(parameterTypes).map(this::resolve).toArray();
                ins = constructor.newInstance(args);
            }
            Field[] fields = FieldsWalker.cachedInjectFields(clazz);
            Arrays.stream(fields).forEach(field -> {
                try {
                    field.setAccessible(true);
                    field.set(ins, this.resolve((Object)field.getType()));
                }
                catch (IllegalAccessException e) {
                    log.error("Access field {} of {} with exception: {}", new Object[]{field.getName(), clazz.getName(), e.getMessage()});
                }
            });
            if (svb.isSington()) {
                svb.setBean(ins);
            }
            return ins;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DependencyResolveException(e.getMessage(), e.getCause());
        }
    }
}

