/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.ioc;

import com.fedepot.ioc.IRegistrationBuilder;
import com.fedepot.ioc.RegistrationData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationBuilder
implements IRegistrationBuilder {
    private static final Logger log = LoggerFactory.getLogger(RegistrationBuilder.class);
    private RegistrationData registrationData;

    private static RegistrationBuilder init() {
        RegistrationBuilder rb = new RegistrationBuilder();
        rb.registrationData = RegistrationData.defaults();
        return rb;
    }

    static <T> RegistrationBuilder forType(Class<T> implementer) {
        RegistrationBuilder rb = RegistrationBuilder.init();
        rb.registrationData.setImplType(implementer);
        return rb;
    }

    static <T> RegistrationBuilder forInstance(T instance) {
        RegistrationBuilder rb = RegistrationBuilder.init();
        rb.registrationData.setSington(true);
        rb.registrationData.setInstance(instance);
        rb.registrationData.setRegType(instance.getClass());
        return rb;
    }

    @Override
    public <T> RegistrationBuilder as(Class<T> implementationType) {
        this.registrationData.setRegType(implementationType);
        return this;
    }

    @Override
    public RegistrationBuilder named(String name) {
        if (this.registrationData.getKey() != null) {
            log.warn("redundant name identity assignment");
            return this;
        }
        this.registrationData.setName(name);
        return this;
    }

    @Override
    public <E extends Enum<E>> RegistrationBuilder keyed(E enumKey) {
        if (!StringUtils.isEmpty((CharSequence)this.registrationData.getName())) {
            log.warn("redundant key identity assignment");
            return this;
        }
        this.registrationData.setKey(enumKey);
        return this;
    }

    @Override
    public RegistrationBuilder instancePerDependency() {
        this.registrationData.setSington(false);
        return this;
    }

    @Override
    public RegistrationBuilder singleInstance() {
        this.registrationData.setSington(true);
        return this;
    }

    public RegistrationData getRegistrationData() {
        return this.registrationData;
    }

    public void setRegistrationData(RegistrationData registrationData) {
        this.registrationData = registrationData;
    }

    private RegistrationBuilder() {
    }
}

