/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.ioc.walker;

import com.fedepot.ioc.annotation.ForInject;
import com.fedepot.ioc.exception.DependencyResolveException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructorWalker {
    private static final Logger log = LoggerFactory.getLogger(ConstructorWalker.class);
    private static final Map<Class<?>, Constructor> constructorMap = new HashMap();

    public static Constructor findInjectConstructor(Class<?> clazz) throws DependencyResolveException {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            log.warn("Class {} has no any public constructors, if it registered as instance this could be ignored, otherwise it will lead to failure when resolving this class", (Object)clazz.getName());
            return null;
        }
        Constructor<?> injectConstructor = constructors[0];
        if (constructors.length > 1) {
            try {
                Constructor<?> annotatedConstructor = null;
                for (Constructor<?> constructor : constructors) {
                    if (constructor.getAnnotation(ForInject.class) == null || annotatedConstructor != null) continue;
                    annotatedConstructor = constructor;
                }
                if (annotatedConstructor != null) {
                    injectConstructor = annotatedConstructor;
                }
            }
            catch (Exception e) {
                log.error("Walk class for constructor encounter exception: {}", (Object)e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
        constructorMap.put(clazz, injectConstructor);
        return injectConstructor;
    }

    public static Constructor cachedInjectConstructor(Class<?> clazz) throws DependencyResolveException {
        Constructor constructor = constructorMap.get(clazz);
        if (constructor != null) {
            return constructor;
        }
        constructor = ConstructorWalker.findInjectConstructor(clazz);
        if (constructor == null) {
            throw new DependencyResolveException("Cannot resolve constructor for Type: " + clazz.getName());
        }
        return constructor;
    }
}

