/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.controller;

import com.fedepot.exception.HttpException;
import com.fedepot.mvc.annotation.RoutePrefix;
import com.fedepot.mvc.controller.IController;
import com.fedepot.mvc.http.ActionResult;
import com.fedepot.mvc.http.ContentType;
import com.fedepot.mvc.http.HttpContext;
import com.fedepot.mvc.http.HttpHeaderNames;
import com.fedepot.mvc.http.Request;
import com.fedepot.mvc.http.Response;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RoutePrefix
public class APIController
implements IController {
    private static final Logger log = LoggerFactory.getLogger(APIController.class);

    protected HttpContext Context() {
        return HttpContext.get();
    }

    protected Request Request() {
        return HttpContext.request();
    }

    protected Response Response() {
        return HttpContext.response();
    }

    protected void JSON(Object json) {
        Response response = this.Response();
        response.header(HttpHeaderNames.CONTENT_TYPE, ContentType.JSON.getMimeTypeWithCharset());
        response.end(ActionResult.build(json, json.getClass()).getBytes(), (String[][])new String[0][]);
    }

    protected void Succeed(Object data) {
        this.Response().status(200);
        this.JSON(data);
    }

    protected void Fail(Exception e) {
        int code = HttpResponseStatus.INTERNAL_SERVER_ERROR.code();
        String msg = e.getMessage();
        if (e instanceof HttpException) {
            code = ((HttpException)e).getCode();
        }
        log.error(msg, (Throwable)e);
        this.Response().status(code);
        this.JSON(msg);
    }
}

