/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.controller;

import com.fedepot.exception.RazorException;
import com.fedepot.mvc.annotation.RoutePrefix;
import com.fedepot.mvc.controller.IController;
import com.fedepot.mvc.http.ContentType;
import com.fedepot.mvc.http.HttpContext;
import com.fedepot.mvc.http.Request;
import com.fedepot.mvc.http.Response;
import com.fedepot.mvc.middleware.Middleware;
import com.fedepot.mvc.renderer.TemplateRenderer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RoutePrefix
public abstract class Controller
implements IController {
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    private final Map<String, Object> viewBag = new HashMap<String, Object>();

    protected HttpContext Context() {
        return HttpContext.get();
    }

    protected Request Request() {
        return HttpContext.request();
    }

    protected Response Response() {
        return HttpContext.response();
    }

    public static Set<Middleware> registerMiddlewares() {
        return null;
    }

    protected void ViewBag(String key, Object value) {
        this.viewBag.put(key, value);
    }

    protected void View(String templatePath) {
        TemplateRenderer renderer = new TemplateRenderer(this.templateFullPath(templatePath));
        this.proxyRender(renderer);
    }

    protected void View(String templatePath, Map<String, Object> data) {
        TemplateRenderer renderer = new TemplateRenderer(this.templateFullPath(templatePath), data);
        this.proxyRender(renderer);
    }

    protected void View(String templatePath, String dataKey, String dataValue) {
        TemplateRenderer renderer = new TemplateRenderer(this.templateFullPath(templatePath), dataKey, dataValue);
        this.proxyRender(renderer);
    }

    private void proxyRender(TemplateRenderer renderer) {
        try {
            renderer.setContentType(ContentType.HTML);
            renderer.setViewBag((Map)this.viewBag);
            renderer.render(HttpContext.request(), HttpContext.response());
        }
        catch (RazorException e) {
            log.error(e.toString());
        }
    }

    private String templateFullPath(String path) {
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        String templateDir = HttpContext.app().getEnv().get("razor.web.template.root", "WEB-INF/templates");
        return templateDir.concat("/").concat(path);
    }
}

