/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.http;

import java.util.HashMap;
import java.util.Map;

public enum ContentType {
    TEXT("text/plain", "text", true, "txt", "text"),
    AUDIO_MPEG("audio/mpeg", "mpeg", false, "mpga", "mp2", "mp2a", "mp3", "m2a", "m3a"),
    AVI("video/x-msvideo", "avi", false, "avi"),
    MP4A("video/mp4", "mp4a", false, "mp4", "mp4a", "mpg4"),
    MP4V("video/mp4v-es", "mp4v", false, "mp4v"),
    WAV("audio/x-wav", "wav", false, "wav"),
    BITTORRENT("application/x-bittorrent", "bittorrent", false, "torrent"),
    JPEG("image/jpeg", "jpeg", true, "jpeg", "jpg", "jpe"),
    BMP("image/x-ms-bmp", "bmp", true, "bmp"),
    PNG("image/png", "png", true, "png"),
    GIF("image/gif", "gif", true, "gif"),
    ICO("image/x-ico", "ico", true, "ico"),
    TIFF("image/tiff", "tiff", true, "tiff", "tif"),
    WEBP("image/webp", "webp", true, "webp"),
    SVG("image/svg+xml", "svg", true, "svg"),
    TTF("application/x-font-ttf", "ttf", true, "ttf"),
    OTF("application/x-font-opentype", "otf", true, "otf"),
    WOFF("application/font-woff", "woff", true, "woff"),
    WOFF2("application/font-woff2", "woff2", true, "woff2"),
    EOT("application/vnd.ms-fontobject", "eot", true, "eot"),
    FLASH("application/x-shockwave-flash", "flash", false, "swf"),
    FLASH_VIDEO("video/x-flv", "flash-video", false, "flv"),
    GNU_INFO("text/x-info", "gnu-info", true, "info"),
    GZIP("application/x-gzip", "gzip", false, "gz"),
    HTML("text/html", "html", true, "html", "htm"),
    JAVASCRIPT("application/javascript", "javascript", true, "js"),
    CSS("text/css", "css", true, "css"),
    JSON("application/json", "json", true, "json"),
    JSON_ML("application/jsonml+json", "jsonml", true, "jsonml"),
    RSS("application/rss+xml", "rss", true, "rss"),
    PDF("application/pdf", "pdf", false, "pdf"),
    CSV("text/csv", "csv", false, "csv"),
    EPUB("application/epub+zip", "epub", false, "epub"),
    MICROSOFT_EXCEL("application/vnd.ms-excel", "excel", false, "xls", "xlm", "xla", "xlc", "xlt", "xlw", "xlsx"),
    MICROSOFT_WORD("application/msword", "word", false, "doc", "dot", "docx"),
    MICROSOFT_ACCESS("application/x-msaccess", "access", false, "mdb"),
    EMPTY("application/octet-stream", "other", true, new String[0]);

    private static final Map<String, ContentType> mimeTypeMap;
    private static final Map<String, ContentType> extensionMap;
    private final String mimeType;
    private final String shortName;
    private final boolean inline;
    private final String[] extensions;

    public String getMimeTypeWithCharset() {
        return this.mimeType.concat("; charset=").concat("utf-8");
    }

    private ContentType(String mimeType, String shortName, boolean inline, String ... extensions) {
        this.mimeType = mimeType;
        this.shortName = shortName;
        this.inline = inline;
        this.extensions = extensions;
    }

    public static ContentType fromMimeType(String mimeType) {
        ContentType type;
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase();
        }
        if ((type = mimeTypeMap.get(mimeType)) == null) {
            return EMPTY;
        }
        return type;
    }

    public static ContentType fromFileExtension(String extension) {
        ContentType type;
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        if ((type = extensionMap.get(extension.toLowerCase())) == null) {
            return EMPTY;
        }
        return type;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean isInline() {
        return this.inline;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    static {
        mimeTypeMap = new HashMap<String, ContentType>();
        extensionMap = new HashMap<String, ContentType>();
        for (ContentType type : ContentType.values()) {
            if (type.mimeType != null) {
                mimeTypeMap.put(type.mimeType.toLowerCase(), type);
            }
            if (type.extensions == null) continue;
            for (String extension : type.extensions) {
                extensionMap.put(extension, type);
            }
        }
    }
}

