/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.http;

import java.beans.ConstructorProperties;

public class Cookie {
    private String name;
    private String value;
    private String path;
    private String domain;
    private long maxAge;
    private boolean httpOnly;
    private boolean secure;
    private boolean sameSite;

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isSameSite() {
        return this.sameSite;
    }

    public void sameSite(boolean value) {
        this.sameSite = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("=").append(this.value).append(";");
        if (this.domain != null) {
            sb.append(" Domain=").append(this.domain).append(";");
        }
        sb.append(" Max-Age=").append(this.maxAge).append(";");
        if (this.path != null) {
            sb.append(" Path=").append(this.path).append(";");
        }
        if (this.secure) {
            sb.append(" Secure;");
        }
        if (this.httpOnly) {
            sb.append(" HttpOnly;");
        }
        if (this.sameSite) {
            sb.append(" SameSite=Strict;");
        }
        return sb.toString();
    }

    private static String $default$path() {
        return "/";
    }

    private static long $default$maxAge() {
        return -1L;
    }

    private static boolean $default$httpOnly() {
        return false;
    }

    private static boolean $default$secure() {
        return false;
    }

    public static CookieBuilder builder() {
        return new CookieBuilder();
    }

    @ConstructorProperties(value={"name", "value", "path", "domain", "maxAge", "httpOnly", "secure", "sameSite"})
    private Cookie(String name, String value, String path, String domain, long maxAge, boolean httpOnly, boolean secure, boolean sameSite) {
        this.name = name;
        this.value = value;
        this.path = path;
        this.domain = domain;
        this.maxAge = maxAge;
        this.httpOnly = httpOnly;
        this.secure = secure;
        this.sameSite = sameSite;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public static class CookieBuilder {
        private String name;
        private String value;
        private boolean path$set;
        private String path;
        private String domain;
        private boolean maxAge$set;
        private long maxAge;
        private boolean httpOnly$set;
        private boolean httpOnly;
        private boolean secure$set;
        private boolean secure;
        private boolean sameSite;

        CookieBuilder() {
        }

        public CookieBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CookieBuilder value(String value) {
            this.value = value;
            return this;
        }

        public CookieBuilder path(String path) {
            this.path = path;
            this.path$set = true;
            return this;
        }

        public CookieBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public CookieBuilder maxAge(long maxAge) {
            this.maxAge = maxAge;
            this.maxAge$set = true;
            return this;
        }

        public CookieBuilder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            this.httpOnly$set = true;
            return this;
        }

        public CookieBuilder secure(boolean secure) {
            this.secure = secure;
            this.secure$set = true;
            return this;
        }

        public CookieBuilder sameSite(boolean sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.name, this.value, this.path$set ? this.path : Cookie.$default$path(), this.domain, this.maxAge$set ? this.maxAge : Cookie.$default$maxAge(), this.httpOnly$set ? this.httpOnly : Cookie.$default$httpOnly(), this.secure$set ? this.secure : Cookie.$default$secure(), this.sameSite);
        }

        public String toString() {
            return "Cookie.CookieBuilder(name=" + this.name + ", value=" + this.value + ", path=" + this.path + ", domain=" + this.domain + ", maxAge=" + this.maxAge + ", httpOnly=" + this.httpOnly + ", secure=" + this.secure + ", sameSite=" + this.sameSite + ")";
        }
    }
}

