/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.http;

import com.google.gson.annotations.Expose;

public class FormFile {
    private String name;
    private String fileName;
    private String contentType;
    private long length;
    @Expose(serialize=false)
    private byte[] data;

    FormFile(String name, String fileName, String contentType, long length) {
        this.name = name;
        this.fileName = fileName;
        this.contentType = contentType;
        this.length = length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FormFile.class.getPackage().getName());
        sb.append(".FormFile(");
        sb.append("name='");
        sb.append(this.name);
        sb.append("', fileName='");
        sb.append(this.fileName);
        sb.append("', contentType='");
        sb.append(this.contentType);
        sb.append("', size=");
        if (this.length < 1024L) {
            sb.append(this.length);
            sb.append("Bytes");
        } else if (this.length < 0x100000L) {
            sb.append(this.length / 1024L);
            sb.append("Kb");
        } else {
            sb.append(this.length / 0x100000L);
            sb.append("Mb");
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getLength() {
        return this.length;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }
}

