/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.http;

import com.fedepot.ioc.annotation.IocIgnore;
import com.fedepot.mvc.http.HttpContext;
import com.fedepot.mvc.http.Session;
import java.util.HashMap;
import java.util.Map;

@IocIgnore
public class HttpSession
implements Session {
    private String id = null;
    private long createAt = -1L;
    private long expireAt = -1L;
    private boolean isFirstTime = false;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public HttpSession(String id, long createAt, long expireAt) {
        this.id = id;
        this.createAt = createAt;
        this.expireAt = expireAt;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public long createAt() {
        return this.createAt;
    }

    @Override
    public long expireAt() {
        return this.expireAt;
    }

    @Override
    public Map<String, Object> attributes() {
        return this.attributes;
    }

    @Override
    public <T> T attribute(String name) {
        Object value = this.attributes.get(name);
        if (value != null) {
            return (T)value;
        }
        return null;
    }

    @Override
    public void addAttribute(String name, Object value) {
        this.attributes.put(name, value);
        this.update();
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
        this.update();
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
        this.update();
    }

    private void update() {
        HttpContext.app().getSessionManager().add(this);
    }
}

