/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.http;

import com.fedepot.Razor;
import com.fedepot.cache.Cache;
import com.fedepot.ioc.annotation.IocIgnore;
import com.fedepot.mvc.Constants;
import com.fedepot.mvc.http.Session;
import com.fedepot.mvc.http.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IocIgnore
public class HttpSessionManager
implements SessionManager {
    private static final Logger log = LoggerFactory.getLogger(HttpSessionManager.class);
    private static final String SESSION_CACHE_GROUP = "_SESSION_";
    private Cache cache;
    private int sessionTimeout;

    public HttpSessionManager(Cache cache, Razor razor) {
        this.cache = cache;
        this.sessionTimeout = razor.getEnv().getInt("razor.web.http.session.timeout", Constants.DEFAULT_SESSION_TIMEOUT);
    }

    @Override
    public void add(Session session) {
        this.cache.add(session.id(), session, this.sessionTimeout, SESSION_CACHE_GROUP);
    }

    @Override
    public void remove(String id) {
        this.cache.delete(id, SESSION_CACHE_GROUP);
    }

    @Override
    public Session get(String id) {
        try {
            return (Session)this.cache.get(id, SESSION_CACHE_GROUP, null);
        }
        catch (Exception e) {
            log.error("Get session from cache has error", (Throwable)e);
            return null;
        }
    }

    @Override
    public void persist() {
    }

    @Override
    public void restore() {
    }
}

