/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.http;

import com.fedepot.exception.NotImplementException;
import com.fedepot.mvc.http.Cookie;
import com.fedepot.mvc.http.FormFile;
import com.fedepot.mvc.http.HttpContext;
import com.fedepot.mvc.http.HttpHeaderNames;
import com.fedepot.mvc.http.Session;
import com.fedepot.mvc.route.PathParameter;
import com.fedepot.mvc.route.RouteManager;
import com.fedepot.mvc.route.Router;
import com.fedepot.server.SessionHandler;
import com.fedepot.util.HttpKit;
import com.fedepot.util.MimeKit;
import com.fedepot.util.UrlKit;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request {
    private static final Logger log = LoggerFactory.getLogger(Request.class);
    private static final HttpDataFactory HTTP_DATA_FACTORY = new DefaultHttpDataFactory(16384L);
    private ChannelHandlerContext channelCxt;
    private FullHttpRequest fullHttpRequest;
    private SessionHandler sessionHandler;
    private String baseUrl;
    private String path;
    private Object body;
    private ByteBuf rawBody;
    private String rawCookie;
    private Map<String, String> cookies;
    private boolean fresh;
    private String hostname;
    private String host;
    private String ip;
    private String ua;
    private String protocol;
    private boolean secure;
    private String method;
    private String origin;
    private boolean matchRoute = false;
    private Router router;
    private PathParameter[] pathParams;
    private Map<String, List<String>> formParams;
    private Map<String, List<String>> queries;
    private Map<String, FormFile> files;
    private Map<String, Object> locals;
    private boolean xhr;
    private boolean isStatic;

    public String path() {
        return this.path;
    }

    public Optional<String> cookie(String name) {
        if (this.cookies == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.cookies.get(name));
    }

    public void cookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(cookie.getName(), cookie.getValue());
    }

    public Session session() {
        return this.sessionHandler.getSession(this);
    }

    public String protocol() {
        return this.protocol;
    }

    public boolean secure() {
        return this.secure;
    }

    public String method() {
        return this.method;
    }

    public boolean matchRoute() {
        return this.matchRoute;
    }

    public Router router() {
        return this.router;
    }

    public Map<String, FormFile> files() {
        return this.files;
    }

    public Optional<FormFile> getFile(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return Optional.ofNullable(this.files.get(name));
    }

    public void locals(String key, Object value) {
        if (this.locals == null) {
            this.locals = new HashMap<String, Object>();
        }
        this.locals.put(key, value);
    }

    public boolean xhr() {
        return this.xhr;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean keepAlive() {
        return HttpUtil.isKeepAlive((HttpMessage)this.fullHttpRequest);
    }

    private Request(ChannelHandlerContext channelCxt, FullHttpRequest fullHttpRequest) {
        Router router;
        String originMethod;
        this.channelCxt = channelCxt;
        this.fullHttpRequest = fullHttpRequest;
        HttpHeaders headers = fullHttpRequest.headers();
        this.host = headers.get("Host");
        Matcher matcher = Pattern.compile("^([^:]+)(:(\\d+))?$").matcher(this.host);
        if (matcher.matches()) {
            this.hostname = matcher.group(1);
        }
        String requestWith = headers.get("X-Requested-With");
        this.xhr = StringUtils.equals((CharSequence)requestWith, (CharSequence)"XMLHttpRequest");
        this.ip = HttpKit.getIP(headers);
        this.ua = headers.get("User-Agent");
        this.method = fullHttpRequest.method().name().toUpperCase();
        if (this.method.equals("OPTIONS")) {
            originMethod = headers.get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD);
            if (originMethod == null) {
                originMethod = "POST";
            }
        } else {
            originMethod = this.method;
        }
        this.origin = headers.get((CharSequence)HttpHeaderNames.ORIGIN);
        this.protocol = headers.get((CharSequence)HttpHeaderNames.X_FORWARDED_PROTO) != null && "https".equals(headers.get((CharSequence)HttpHeaderNames.X_FORWARDED_PROTO).toLowerCase()) ? "https" : "http";
        this.secure = StringUtils.equals((CharSequence)this.protocol, (CharSequence)"https");
        this.rawCookie = fullHttpRequest.headers().get("Cookie");
        this.baseUrl = fullHttpRequest.uri();
        this.rawBody = fullHttpRequest.content().copy();
        this.path = UrlKit.purgeUrlQueries(this.baseUrl);
        this.queries = UrlKit.parseQueries(this.baseUrl);
        this.isStatic = UrlKit.isStaticFile(HttpContext.app().getStatics(), this.path);
        if (this.isStatic) {
            return;
        }
        String contentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (!this.method.equals("GET") && contentType != null && (contentType.startsWith("application/json") || contentType.startsWith("application/x-www-form-urlencoded") || contentType.startsWith("multipart/form-data"))) {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder(HTTP_DATA_FACTORY, (HttpRequest)fullHttpRequest);
            decoder.getBodyHttpDatas().forEach(this::parseBodyData);
        }
        if ((router = RouteManager.getInstance(HttpContext.app()).findRoute(this.path, originMethod)) != null) {
            this.matchRoute = true;
            this.router = router;
            if (!this.method.equals("OPTIONS")) {
                this.pathParams = router.getRouteMatcher().getParams(this.path);
            }
        }
    }

    public static Request build(ChannelHandlerContext cxt, FullHttpRequest req, SessionHandler sessionHandler) {
        Request request = new Request(cxt, req);
        request.sessionHandler = sessionHandler;
        return request;
    }

    public String accept(String docType) {
        throw new NotImplementException();
    }

    public String accept(String[] docTypes) {
        throw new NotImplementException();
    }

    public String get(String field) {
        return this.fullHttpRequest.headers().get(field);
    }

    public String get(AsciiString field) {
        return this.fullHttpRequest.headers().get((CharSequence)field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBodyData(InterfaceHttpData data) {
        try {
            switch (data.getHttpDataType()) {
                case Attribute: {
                    Attribute attribute = (Attribute)data;
                    if (this.formParams == null) {
                        this.formParams = new HashMap<String, List<String>>();
                    }
                    this.formParams.put(attribute.getName(), Arrays.asList(attribute.getValue()));
                    return;
                }
                case FileUpload: {
                    FileUpload fileUpload = (FileUpload)data;
                    this.handleFileUpload(fileUpload);
                    return;
                }
            }
            return;
        }
        catch (IOException e) {
            log.error("Parse request form data with error", (Throwable)e);
            return;
        }
        finally {
            data.release();
        }
    }

    private void handleFileUpload(FileUpload fileUpload) throws IOException {
        if (fileUpload.isCompleted()) {
            String contentType = MimeKit.of(fileUpload.getFilename());
            if (contentType == null) {
                contentType = URLConnection.guessContentTypeFromName(fileUpload.getFilename());
            }
            FormFile formFile = new FormFile(fileUpload.getName(), fileUpload.getFilename(), contentType, fileUpload.length());
            if (fileUpload.isInMemory()) {
                formFile.setData(fileUpload.getByteBuf().array());
            } else {
                formFile.setData(Files.readAllBytes(fileUpload.getFile().toPath()));
            }
            if (this.files == null) {
                this.files = new HashMap<String, FormFile>();
            }
            this.files.put(fileUpload.getName(), formFile);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public ByteBuf getRawBody() {
        return this.rawBody;
    }

    public String getRawCookie() {
        return this.rawCookie;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHost() {
        return this.host;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUa() {
        return this.ua;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getOrigin() {
        return this.origin;
    }

    public PathParameter[] getPathParams() {
        return this.pathParams;
    }

    public Map<String, List<String>> getFormParams() {
        return this.formParams;
    }

    public Map<String, List<String>> getQueries() {
        return this.queries;
    }

    public Map<String, Object> getLocals() {
        return this.locals;
    }
}

