/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.http;

import com.fedepot.exception.NotImplementException;
import com.fedepot.mvc.http.ContentType;
import com.fedepot.mvc.http.Cookie;
import com.fedepot.mvc.http.HttpContext;
import com.fedepot.mvc.http.HttpHeaderNames;
import com.fedepot.mvc.http.Request;
import com.fedepot.mvc.json.GsonFactory;
import com.fedepot.server.ProgressiveFutureListener;
import com.fedepot.util.DateKit;
import com.fedepot.util.MimeKit;
import com.google.gson.Gson;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Response {
    private ChannelHandlerContext channelCxt;
    private boolean keepAlive = true;
    private long startAt = 0L;
    private boolean flushed = false;
    private Request request;
    private HttpResponse httpResponse;
    private Map<AsciiString, AsciiString> headerQueue = new HashMap<AsciiString, AsciiString>();
    private List<String> cookieHeaderQueue = new ArrayList<String>();
    private HttpResponseStatus status;

    public boolean flushed() {
        return this.flushed;
    }

    private void setHttpResponse(HttpResponse response) {
        this.httpResponse = response;
        Iterator<Map.Entry<AsciiString, AsciiString>> iterator = this.headerQueue.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AsciiString, AsciiString> entry = iterator.next();
            AsciiString field = entry.getKey();
            AsciiString value = entry.getValue();
            if (!field.isEmpty() && !value.isEmpty()) {
                this.httpResponse.headers().set((CharSequence)entry.getKey(), (Object)entry.getValue());
            }
            iterator.remove();
        }
        this.httpResponse.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, this.cookieHeaderQueue);
        this.cookieHeaderQueue.clear();
    }

    public HttpResponseStatus getStatus() {
        if (this.status == null) {
            return HttpResponseStatus.OK;
        }
        return this.status;
    }

    private Response(ChannelHandlerContext cxt, FullHttpResponse res) {
        this.channelCxt = cxt;
        this.request = HttpContext.request();
        this.httpResponse = res;
        if (this.request != null && !this.request.keepAlive()) {
            this.keepAlive = false;
        }
        this.startAt = System.currentTimeMillis();
    }

    public static Response build(ChannelHandlerContext cxt, FullHttpResponse res) {
        return new Response(cxt, res);
    }

    public static Response build(ChannelHandlerContext cxt) {
        return new Response(cxt, null);
    }

    public Response header(AsciiString field, AsciiString value) {
        if (this.httpResponse == null) {
            this.headerQueue.put(field, value);
        } else {
            this.httpResponse.headers().set((CharSequence)field, (Object)value);
        }
        return this;
    }

    public Response header(AsciiString field, String value) {
        return this.header(field, new AsciiString((CharSequence)value));
    }

    public Response header(String field, String value) {
        return this.header(new AsciiString((CharSequence)field), new AsciiString((CharSequence)value));
    }

    public String get(AsciiString field) {
        if (this.httpResponse != null) {
            return this.httpResponse.headers().get((CharSequence)field);
        }
        AsciiString value = this.headerQueue.get(field);
        if (value != null && !value.isEmpty()) {
            return value.toString();
        }
        return null;
    }

    public String get(String field) {
        return this.get(new AsciiString((CharSequence)field));
    }

    public Response attachment() {
        this.header(HttpHeaderNames.CONTENT_DISPOSITION, "attachment");
        return this;
    }

    public Response attachment(String filePath) {
        int index = filePath.lastIndexOf("/");
        String filename = index > -1 ? filePath.substring(index + 1) : filePath;
        String mime = MimeKit.detailOf(filename).getMimeTypeWithCharset();
        this.header(HttpHeaderNames.CONTENT_DISPOSITION, "attachment; filename=".concat(filename));
        this.header(HttpHeaderNames.CONTENT_TYPE, mime);
        return this;
    }

    public Response cookie(String name, String value) {
        return this.cookie(name, value, null);
    }

    public Response cookie(String name, String value, Map<String, Object> options) {
        StringBuilder sb = new StringBuilder(name);
        sb.append("=").append(value).append(";");
        if (options != null) {
            Object sameSite;
            Object httpOnly;
            Object secure;
            Object path;
            Object maxAge;
            Object domain = options.get("domain");
            if (domain != null) {
                sb.append(" Domain=").append(domain.toString()).append(";");
            }
            if ((maxAge = options.get("maxAge")) != null) {
                sb.append(" Max-Age=").append(maxAge.toString()).append(";");
            }
            if ((path = options.get("path")) != null) {
                sb.append(" Path=").append(path.toString()).append(";");
            }
            if ((secure = options.get("secure")) != null && ((Boolean)secure).booleanValue()) {
                sb.append(" Secure;");
            }
            if ((httpOnly = options.get("httpOnly")) != null && ((Boolean)httpOnly).booleanValue()) {
                sb.append(" HttpOnly;");
            }
            if ((sameSite = options.get("sameSite")) != null && ((Boolean)sameSite).booleanValue()) {
                sb.append(" SameSite=Strict;");
            }
        }
        if (this.httpResponse == null) {
            this.cookieHeaderQueue.add(sb.toString());
        } else {
            this.httpResponse.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)sb.toString());
        }
        return this;
    }

    public Response cookie(Cookie cookie) {
        if (this.httpResponse == null) {
            this.cookieHeaderQueue.add(cookie.toString());
        } else {
            this.httpResponse.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)cookie.toString());
        }
        return this;
    }

    public Response clearCookie(String name) {
        Cookie cookie = Cookie.builder().name(name).maxAge(-1L).build();
        return this.cookie(cookie);
    }

    public Response status(int statusCode) {
        this.status = HttpResponseStatus.valueOf((int)statusCode);
        return this;
    }

    public void setDate() {
        this.header(HttpHeaderNames.DATE, DateKit.getGmtDateString());
    }

    public void setPowerBy() {
        this.header(HttpHeaderNames.SERVER, "Netty");
        this.header(HttpHeaderNames.X_POWERED_BY, "Razor");
    }

    public void setResponseTime() {
        long elapsedTime = System.currentTimeMillis() - this.startAt;
        this.header(HttpHeaderNames.X_RESPONSE_TIME, elapsedTime + "ms");
    }

    public void json(Object data) {
        this.header(HttpHeaderNames.CONTENT_TYPE, ContentType.JSON.getMimeTypeWithCharset());
        Gson gson = GsonFactory.getGson();
        String text = gson.toJson(data);
        this.end(text, (String[][])new String[0][]);
    }

    public void redirect(String path) {
        this.redirect(path, 302);
    }

    public void redirect(String path, int code) {
        this.keepAlive = false;
        this.header(HttpHeaderNames.LOCATION, path);
        if (code < 300 || code >= 400) {
            code = 302;
        }
        this.status = HttpResponseStatus.valueOf((int)code);
        this.end();
    }

    public void location(String path) {
        throw new NotImplementException();
    }

    public Response type(String type) {
        String mime = MimeKit.get(type);
        if (mime != null) {
            this.header(HttpHeaderNames.CONTENT_TYPE, mime.concat("; charset=").concat("utf-8"));
        }
        return this;
    }

    public Response vary(String field) {
        String vary = this.get(HttpHeaderNames.VARY);
        if (vary != null) {
            this.header(HttpHeaderNames.VARY, vary.concat(", ").concat(field));
        } else {
            this.header(HttpHeaderNames.VARY, field);
        }
        return this;
    }

    public void send(Object data) {
        throw new NotImplementException();
    }

    public void sendStatus(int code) {
        this.status(code).end(HttpResponseStatus.valueOf((int)code).reasonPhrase(), (String[][])new String[0][]);
    }

    public void sendError(HttpResponseStatus status) {
        this.status = status;
        this.setHttpResponse((HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)status.toString(), (Charset)CharsetUtil.UTF_8)));
        this.header(HttpHeaderNames.CONTENT_TYPE, "text/plain; charset=utf-8");
        this.writeFlush(true);
    }

    public void forbidden() {
        String html = HttpContext.app().getEnv().get("razor.runtime.web.html.403").orElse("");
        this.keepAlive = false;
        if (!"".equals(html)) {
            this.header(HttpHeaderNames.CONTENT_TYPE, ContentType.HTML.getMimeTypeWithCharset()).status(403).end(html, (String[][])new String[0][]);
        } else {
            this.sendStatus(403);
        }
    }

    public void notFound() {
        String html = HttpContext.app().getEnv().get("razor.runtime.web.html.404").orElse("");
        this.keepAlive = false;
        if (!"".equals(html)) {
            this.header(HttpHeaderNames.CONTENT_TYPE, ContentType.HTML.getMimeTypeWithCharset()).status(404).end(html, (String[][])new String[0][]);
        } else {
            this.sendStatus(404);
        }
    }

    public void interanlError() {
        String html = HttpContext.app().getEnv().get("razor.runtime.web.html.500").orElse("");
        this.keepAlive = false;
        if (!"".equals(html)) {
            this.header(HttpHeaderNames.CONTENT_TYPE, ContentType.HTML.getMimeTypeWithCharset()).status(500).end(html, (String[][])new String[0][]);
        } else {
            this.sendStatus(500);
        }
    }

    public void badGateway() {
        String html = HttpContext.app().getEnv().get("razor.runtime.web.html.502").orElse("");
        this.keepAlive = false;
        if (!"".equals(html)) {
            this.header(HttpHeaderNames.CONTENT_TYPE, ContentType.HTML.getMimeTypeWithCharset()).status(502).end(html, (String[][])new String[0][]);
        } else {
            this.sendStatus(502);
        }
    }

    public void sendFile(RandomAccessFile raf, long length) {
        this.setDate();
        this.setPowerBy();
        this.setResponseTime();
        this.header(HttpHeaderNames.CONTENT_LENGTH, Long.toString(length));
        this.setHttpResponse((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.getStatus(), true));
        this.channelCxt.write((Object)this.httpResponse);
        ChannelFuture sendFileFuture = this.channelCxt.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, length), (ChannelPromise)this.channelCxt.newProgressivePromise());
        ChannelFuture lastContentFuture = this.channelCxt.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        sendFileFuture.addListener((GenericFutureListener)new ProgressiveFutureListener(raf));
        if (!this.keepAlive) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        this.flush();
    }

    public void download() {
        throw new NotImplementException();
    }

    private void writeFlush(boolean close) {
        if (this.flushed()) {
            return;
        }
        this.setDate();
        this.setPowerBy();
        this.setResponseTime();
        if (close) {
            this.channelCxt.writeAndFlush((Object)this.httpResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            this.header(HttpHeaderNames.CONNECTION, "keep-alive");
            this.channelCxt.writeAndFlush((Object)this.httpResponse);
        }
        this.flush();
    }

    private void flush() {
        this.flushed = true;
        this.request = null;
        this.httpResponse = null;
    }

    public void end() {
        this.end(Unpooled.EMPTY_BUFFER.toString(CharsetUtil.UTF_8), (String[][])new String[0][]);
    }

    public void end(String data, String[] ... options) {
        this.header(HttpHeaderNames.CONTENT_LENGTH, Integer.toString(data.length()));
        if (this.httpResponse == null) {
            this.setHttpResponse((HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.getStatus(), Unpooled.copiedBuffer((CharSequence)data, (Charset)CharsetUtil.UTF_8)));
        }
        this.writeFlush(!this.keepAlive);
    }

    public void end(byte[] data, String[] ... options) {
        this.setHttpResponse((HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.getStatus(), Unpooled.copiedBuffer((byte[])data)));
        this.header(HttpHeaderNames.CONTENT_LENGTH, Integer.toString(data.length));
        this.writeFlush(!this.keepAlive);
    }
}

