/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.middleware;

import com.fedepot.mvc.http.Request;
import com.fedepot.mvc.http.Response;
import com.fedepot.mvc.middleware.Middleware;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.HashMap;
import java.util.List;

public class CookieParserMiddleware
implements Middleware {
    @Override
    public void apply(Request req, Response res) {
        String cookie = req.getRawCookie();
        if (cookie != null && !cookie.isEmpty()) {
            HashMap<String, String> cookieMap = new HashMap<String, String>();
            QueryStringDecoder decoder = new QueryStringDecoder(cookie, false);
            for (String key : decoder.parameters().keySet()) {
                List values = (List)decoder.parameters().get(key);
                if (values != null && values.get(0) != null) {
                    cookieMap.put(key.trim(), (String)values.get(0));
                    continue;
                }
                cookieMap.put(key.trim(), "");
            }
            req.setCookies(cookieMap);
        }
    }
}

