/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.middleware;

import com.fedepot.mvc.http.HttpHeaderNames;
import com.fedepot.mvc.http.Request;
import com.fedepot.mvc.http.Response;
import com.fedepot.mvc.middleware.Middleware;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CorsMiddleware
implements Middleware {
    private Set<String> whitelist;

    public CorsMiddleware() {
        this.whitelist = new HashSet<String>();
        this.whitelist.add("*");
    }

    public CorsMiddleware(String ... originWhitelist) {
        this.whitelist = new HashSet<String>(Arrays.asList(originWhitelist));
    }

    @Override
    public void apply(Request req, Response res) {
        String allowOrigin = null;
        String origin = req.getOrigin();
        if (origin == null || origin.isEmpty()) {
            return;
        }
        if (this.whitelist.contains(origin)) {
            allowOrigin = origin;
        } else if (this.whitelist.contains("*")) {
            allowOrigin = "*";
        }
        if (allowOrigin != null) {
            res.header(HttpHeaderNames.VARY, "Origin");
            res.header(HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
            res.header(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, allowOrigin);
            res.header(HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, "GET, POST, PUT, DELETE");
            res.header(HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, "X-Requested-With, X-CSRF-Token, Authorization, Content-Type, Ajax");
            if (req.method().equals("OPTIONS")) {
                res.end("ok", (String[][])new String[0][]);
            }
        } else {
            res.sendStatus(405);
        }
    }
}

