/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.renderer;

import com.fedepot.exception.RazorException;
import com.fedepot.mvc.http.ContentType;
import com.fedepot.mvc.http.HttpHeaderNames;
import com.fedepot.mvc.http.Request;
import com.fedepot.mvc.http.Response;
import com.fedepot.mvc.renderer.Renderer;
import com.fedepot.mvc.template.TemplateEngineFactory;
import java.util.HashMap;
import java.util.Map;

public class TemplateRenderer
extends Renderer {
    private String templatePath;
    private Map<String, Object> model;

    public TemplateRenderer(String path) {
        this.templatePath = path;
        this.model = new HashMap<String, Object>();
    }

    public TemplateRenderer(String path, Map<String, Object> model) {
        this.templatePath = path;
        this.model = model;
    }

    public TemplateRenderer(String path, String dataKey, Object dataValue) {
        this.templatePath = path;
        this.model = new HashMap<String, Object>();
        this.model.put(dataKey, dataValue);
    }

    @Override
    public void render(Request request, Response response) throws RazorException {
        try {
            this.model.put("VIEWBAG", this.getViewBag());
            String view = TemplateEngineFactory.getEngine().render(this.templatePath, this.model);
            if (response.get(HttpHeaderNames.CONTENT_TYPE) == null) {
                ContentType contentType = this.getContentType() != null ? this.getContentType() : ContentType.TEXT;
                response.header(HttpHeaderNames.CONTENT_TYPE, contentType.getMimeTypeWithCharset());
            }
            response.end(view, (String[][])new String[0][]);
        }
        catch (Exception e) {
            throw new RazorException(e);
        }
    }
}

