/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.route;

import com.fedepot.Razor;
import com.fedepot.mvc.annotation.HttpAll;
import com.fedepot.mvc.annotation.HttpDelete;
import com.fedepot.mvc.annotation.HttpPost;
import com.fedepot.mvc.annotation.HttpPut;
import com.fedepot.mvc.annotation.Route;
import com.fedepot.mvc.annotation.RoutePrefix;
import com.fedepot.mvc.controller.APIController;
import com.fedepot.mvc.controller.Controller;
import com.fedepot.mvc.route.RouteMatcher;
import com.fedepot.mvc.route.Router;
import com.fedepot.util.ReflectKit;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteManager {
    private static final Logger log = LoggerFactory.getLogger(RouteManager.class);
    private static RouteManager instance;
    private Razor razor;
    private Class<?> appClass;
    private final Map<String, Router> routerMap = new HashMap<String, Router>();
    private final Set<Router> routerSet = new HashSet<Router>();

    private RouteManager(Razor razor) {
        this.razor = razor;
        this.appClass = razor.getAppClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RouteManager getInstance(Razor razor) {
        if (instance != null) return instance;
        Class<RouteManager> clazz = RouteManager.class;
        synchronized (RouteManager.class) {
            if (instance != null) return instance;
            instance = new RouteManager(razor);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void registerRoutes() {
        Reflections reflections = ReflectKit.getReflections(this.appClass);
        Set controllers = reflections.getSubTypesOf(Controller.class);
        Set apiControllers = reflections.getSubTypesOf(APIController.class);
        controllers.forEach(this::parseControllerRoutes);
        apiControllers.forEach(this::parseControllerRoutes);
    }

    private void parseControllerRoutes(Class<?> clazz) {
        Method[] actions;
        String routePrefix = "";
        RoutePrefix rpAnnotation = clazz.getAnnotation(RoutePrefix.class);
        if (rpAnnotation != null) {
            routePrefix = rpAnnotation.value();
        }
        for (Method action : actions = clazz.getDeclaredMethods()) {
            Route rtAnnotation = action.getAnnotation(Route.class);
            if (rtAnnotation == null) continue;
            String route = rtAnnotation.value();
            assert (!StringUtils.isEmpty((CharSequence)route)) : action.getName() + " Route should not have a empty path";
            RouteMatcher matcher = new RouteMatcher(routePrefix, route);
            assert (matcher.isValid()) : clazz.getName().concat(" controller Route prefix or ").concat(action.getName()).concat(" action route has invalid format");
            HttpPost postAnnotation = action.getAnnotation(HttpPost.class);
            HttpPut putAnnotation = action.getAnnotation(HttpPut.class);
            HttpDelete delAnnotation = action.getAnnotation(HttpDelete.class);
            HttpAll httpAllAnnotation = action.getAnnotation(HttpAll.class);
            String httpMethod = httpAllAnnotation != null ? "ALL" : (delAnnotation != null ? "DELETE" : (putAnnotation != null ? "PUT" : (postAnnotation != null ? "POST" : "GET")));
            this.addRoute(new Router(httpMethod, clazz, action, matcher));
        }
    }

    private void addRoute(Router router) {
        router.collectMiddlewares(this.razor);
        if (router.isGeneric()) {
            this.routerSet.add(router);
        } else {
            this.routerMap.put(router.getHashKey(), router);
        }
    }

    public Router findRoute(String path, String httpMethod) {
        Router router = this.routerMap.get(path.concat("::").concat(httpMethod));
        if (router != null) {
            return router;
        }
        router = this.routerMap.get(path.concat("::").concat("ALL"));
        if (router != null) {
            return router;
        }
        for (Router router1 : this.routerSet) {
            String routerHttpMethod = router1.getHttpMethod();
            if (!routerHttpMethod.equals("ALL") && !StringUtils.equals((CharSequence)routerHttpMethod, (CharSequence)httpMethod) || !router1.match(path)) continue;
            return router1;
        }
        return null;
    }

    public Router findRoute(String path) {
        return this.findRoute(path, "GET");
    }
}

