/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.route;

import com.fedepot.mvc.route.PathParameter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteMatcher {
    private static final Logger log = LoggerFactory.getLogger(RouteMatcher.class);
    private static Pattern ROUTE_PREFIX_PATTERN = Pattern.compile("^/([0-9a-zA-Z-_/]+)?$");
    private static Pattern ROUTE_PATTERN = Pattern.compile("^(([^/])([0-9a-zA-Z-_/{}:.]+)([^/]))?$");
    private String routePrefix;
    private String route;
    private String[] paramTypes;
    private String[] paramNames;
    private Pattern pattern;
    private boolean isValid = true;
    private boolean isUniversal = false;

    boolean isValid() {
        return this.isValid;
    }

    boolean isUniversal() {
        return this.isUniversal;
    }

    String getRoutePrefix() {
        return this.routePrefix;
    }

    public String getRoute() {
        return this.route;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public String[] getParamTypes() {
        return this.paramTypes;
    }

    public PathParameter[] getParams(String path) {
        int paramCount = Math.min(this.paramTypes.length, this.paramNames.length);
        if (paramCount < 1) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(path);
        if (!matcher.find()) {
            return null;
        }
        PathParameter[] params = new PathParameter[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            String value = matcher.group(i + 1);
            params[i] = StringUtils.equals((CharSequence)this.paramTypes[i], (CharSequence)"int") ? new PathParameter(this.paramNames[i], Integer.parseInt(value)) : (StringUtils.equals((CharSequence)this.paramTypes[i], (CharSequence)"long") ? new PathParameter(this.paramNames[i], Long.parseLong(value)) : new PathParameter(this.paramNames[i], value));
        }
        return params;
    }

    Pattern getPattern() {
        return this.pattern;
    }

    RouteMatcher(String routePrefix, String route) {
        this.routePrefix = routePrefix.startsWith("/") ? routePrefix : "/".concat(routePrefix);
        this.route = route;
        boolean bl = this.isUniversal = "*".equals(route) || route.contains("/*") || Pattern.compile("\\{([0-9a-zA-Z]+)?:?([0-9a-zA-Z_]+)}").matcher(route).find();
        if (!this.validateRoutes()) {
            this.isValid = false;
            return;
        }
        int start = 0;
        boolean inPair = false;
        boolean inName = false;
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder currentParamType = new StringBuilder();
        StringBuilder currentParamName = new StringBuilder();
        StringBuilder patternBuilder = new StringBuilder("^");
        patternBuilder.append(this.routePrefix);
        if (!this.routePrefix.endsWith("/")) {
            patternBuilder.append("/");
        }
        while (start < route.length()) {
            String ch = route.substring(start, start + 1);
            if (StringUtils.equals((CharSequence)ch, (CharSequence)"{")) {
                inPair = true;
                inName = false;
                currentParamType.setLength(0);
                currentParamName.setLength(0);
            } else if (StringUtils.equals((CharSequence)ch, (CharSequence)"}")) {
                inPair = false;
                inName = false;
                if (StringUtils.isEmpty((CharSequence)currentParamName.toString())) {
                    types.add("String");
                    names.add(currentParamType.toString());
                    patternBuilder.append("([0-9a-zA-Z-_]+)");
                } else {
                    boolean isNumber;
                    boolean bl2 = isNumber = StringUtils.equals((CharSequence)currentParamType.toString().toLowerCase(), (CharSequence)"int") || StringUtils.equals((CharSequence)currentParamType.toString().toLowerCase(), (CharSequence)"long");
                    if (isNumber) {
                        types.add(currentParamType.toString().toLowerCase());
                    } else {
                        types.add("String");
                    }
                    names.add(currentParamName.toString());
                    patternBuilder.append(isNumber ? "([0-9]+)" : "([0-9a-zA-Z-_]+)");
                }
            } else if (StringUtils.equals((CharSequence)ch, (CharSequence)":")) {
                inName = true;
            } else if (inPair) {
                if (inName) {
                    currentParamName.append(ch);
                } else {
                    currentParamType.append(ch);
                }
            } else {
                patternBuilder.append("*".equals(ch) ? "([0-9a-zA-Z-_./]+)?" : ch);
            }
            ++start;
        }
        patternBuilder.append("$");
        this.pattern = Pattern.compile(patternBuilder.toString());
        this.paramNames = names.toArray(new String[0]);
        this.paramTypes = types.toArray(new String[0]);
    }

    private boolean validateRoutes() {
        Matcher matcher = ROUTE_PREFIX_PATTERN.matcher(this.routePrefix);
        if (!matcher.matches()) {
            log.error("Route Prefix {} is illegal, should consist of '0-9 a-z A-Z - _ /'", (Object)this.routePrefix);
            return false;
        }
        if ("*".equals(this.route)) {
            return true;
        }
        matcher = ROUTE_PATTERN.matcher(this.route.replace(" ", ""));
        if (!matcher.matches()) {
            log.error("Route {} is illegal", (Object)this.route);
        }
        return true;
    }
}

