/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.route;

import com.fedepot.exception.RazorException;
import com.fedepot.mvc.annotation.FormFiles;
import com.fedepot.mvc.annotation.FromBody;
import com.fedepot.mvc.annotation.QueryParam;
import com.fedepot.mvc.http.ContentType;
import com.fedepot.mvc.http.HttpHeaderNames;
import com.fedepot.mvc.http.Request;
import com.fedepot.mvc.http.Response;
import com.fedepot.mvc.json.GsonFactory;
import com.fedepot.mvc.route.PathParameter;
import com.fedepot.mvc.route.Router;
import io.netty.util.CharsetUtil;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RouteSignature {
    private Router router;
    private Method action;
    private Object[] parameters;
    private Request request;
    private Response response;

    public Request request() {
        return this.request;
    }

    public Response response() {
        return this.response;
    }

    public void setRouter(Router router) throws RazorException {
        this.router = router;
        this.action = router.getAction();
        if (this.action != null && this.request != null && !this.request.method().equals("OPTIONS")) {
            this.initParams();
        }
    }

    private void initParams() throws RazorException {
        if (this.request == null) {
            throw new RazorException("Empty request error");
        }
        if (this.action == null) {
            throw new RazorException("Null route action error");
        }
        int actionParamCount = this.action.getParameterCount();
        if (actionParamCount == 0) {
            this.parameters = new Object[0];
            return;
        }
        PathParameter[] routeParams = this.request.getPathParams();
        Parameter[] actionParams = this.action.getParameters();
        Object[] paramValues = new Object[actionParamCount];
        int i = 0;
        for (Parameter parameter : actionParams) {
            if (routeParams != null && i < routeParams.length) {
                paramValues[i] = routeParams[i].getValue();
            } else {
                Annotation[] annotations = parameter.getAnnotations();
                if (annotations.length > 0) {
                    if (annotations[0].annotationType() == FormFiles.class) {
                        paramValues[i] = this.request.files();
                    } else if (annotations[0].annotationType() == QueryParam.class) {
                        List<String> queries = this.request.getQueries().get(((QueryParam)annotations[0]).value());
                        paramValues[i] = queries == null ? null : (parameter.getType() == String.class ? (queries.size() > 0 ? queries.get(0) : "") : (parameter.getType() == Integer.class || parameter.getType() == Integer.TYPE ? Integer.valueOf(queries.size() > 0 ? Integer.valueOf(queries.get(0)) : 0) : (parameter.getType() == Long.class || parameter.getType() == Long.TYPE ? Long.valueOf(queries.size() > 0 ? Long.valueOf(queries.get(0)) : 0L) : queries)));
                    } else if (annotations[0].annotationType() == FromBody.class) {
                        if (this.request.get(HttpHeaderNames.CONTENT_TYPE).toLowerCase().equals(ContentType.JSON.getMimeType())) {
                            Object value;
                            String rawBody = this.request.getRawBody().toString(CharsetUtil.UTF_8);
                            paramValues[i] = value = GsonFactory.getGson().fromJson(rawBody, parameter.getType());
                            this.request.setBody(value);
                        } else if (this.request.getFormParams() != null) {
                            Object value;
                            Map<String, List<String>> formParams = this.request.getFormParams();
                            HashMap<String, Object> formatFormParams = new HashMap<String, Object>();
                            for (String key : formParams.keySet()) {
                                List<String> valueList = formParams.get(key);
                                if (valueList != null && valueList.size() == 1) {
                                    formatFormParams.put(key, valueList.get(0));
                                    continue;
                                }
                                formatFormParams.put(key, valueList);
                            }
                            String json = GsonFactory.getGson().toJson(formatFormParams);
                            paramValues[i] = value = GsonFactory.getGson().fromJson(json, parameter.getType());
                        } else {
                            paramValues[i] = null;
                        }
                    }
                } else {
                    paramValues[i] = null;
                }
            }
            ++i;
        }
        this.parameters = paramValues;
    }

    @ConstructorProperties(value={"router", "action", "parameters", "request", "response"})
    RouteSignature(Router router, Method action, Object[] parameters, Request request, Response response) {
        this.router = router;
        this.action = action;
        this.parameters = parameters;
        this.request = request;
        this.response = response;
    }

    public static RouteSignatureBuilder builder() {
        return new RouteSignatureBuilder();
    }

    public Router getRouter() {
        return this.router;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public static class RouteSignatureBuilder {
        private Router router;
        private Method action;
        private Object[] parameters;
        private Request request;
        private Response response;

        RouteSignatureBuilder() {
        }

        public RouteSignatureBuilder router(Router router) {
            this.router = router;
            return this;
        }

        public RouteSignatureBuilder action(Method action) {
            this.action = action;
            return this;
        }

        public RouteSignatureBuilder parameters(Object[] parameters) {
            this.parameters = parameters;
            return this;
        }

        public RouteSignatureBuilder request(Request request) {
            this.request = request;
            return this;
        }

        public RouteSignatureBuilder response(Response response) {
            this.response = response;
            return this;
        }

        public RouteSignature build() {
            return new RouteSignature(this.router, this.action, this.parameters, this.request, this.response);
        }

        public String toString() {
            return "RouteSignature.RouteSignatureBuilder(router=" + this.router + ", action=" + this.action + ", parameters=" + Arrays.deepToString(this.parameters) + ", request=" + this.request + ", response=" + this.response + ")";
        }
    }
}

