/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.route;

import com.fedepot.Razor;
import com.fedepot.mvc.middleware.Middleware;
import com.fedepot.mvc.route.RouteMatcher;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Router {
    private static Pattern PATH_PATTERN = Pattern.compile("^(/[0-9a-zA-Z-_./]+)?(/[0-9a-zA-Z-_.]*\\{.+}.*)?((/\\*)(.*))?$");
    private RouteMatcher routeMatcher;
    private String httpMethod;
    private Class<?> targetType;
    private Method action;
    private List<Middleware> middlewares;

    Router(String httpMethod, Class<?> targetType, Method action, RouteMatcher routeMatcher) {
        this.httpMethod = httpMethod.toUpperCase();
        this.targetType = targetType;
        this.action = action;
        this.routeMatcher = routeMatcher;
    }

    boolean match(String url) {
        return this.routeMatcher.getPattern().matcher(url).matches();
    }

    private String getFullPath() {
        String routePrefix = this.routeMatcher.getRoutePrefix();
        String route = this.routeMatcher.getRoute();
        if (route == null || route.isEmpty()) {
            return routePrefix;
        }
        if (routePrefix.endsWith("/")) {
            return routePrefix.concat(route);
        }
        return routePrefix.concat("/").concat(route);
    }

    String getHashKey() {
        return this.getFullPath().concat("::").concat(this.httpMethod.toUpperCase());
    }

    boolean isGeneric() {
        return this.routeMatcher.isUniversal();
    }

    void collectMiddlewares(Razor razor) {
        Matcher matcher;
        ArrayList<Middleware> collection = new ArrayList<Middleware>(razor.getRootMiddlewares());
        String path = this.getFullPath();
        if (!"/*".equals(path) && (matcher = PATH_PATTERN.matcher(path)).matches() && !matcher.group(1).equals(path)) {
            path = matcher.group(1).concat("/*");
        }
        for (String key : razor.getPathMiddlewares().keySet()) {
            boolean match = false;
            if (key.equals(path)) {
                match = true;
            } else if (key.endsWith("/*") && path.startsWith(key.substring(0, key.length() - 1))) {
                match = true;
            }
            if (!match) continue;
            collection.addAll((Collection<Middleware>)razor.getPathMiddlewares().get(key));
        }
        Collections.sort(collection);
        this.middlewares = collection;
    }

    public RouteMatcher getRouteMatcher() {
        return this.routeMatcher;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public Method getAction() {
        return this.action;
    }

    public List<Middleware> getMiddlewares() {
        return this.middlewares;
    }
}

