/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.mvc.template;

import com.fedepot.mvc.http.HttpContext;
import com.fedepot.mvc.http.Session;
import com.fedepot.mvc.template.TemplateEngine;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeetlTemplateEngine
implements TemplateEngine {
    private static final Logger log = LoggerFactory.getLogger(BeetlTemplateEngine.class);
    private GroupTemplate groupTemplate;

    private GroupTemplate getGroupTemplate() {
        if (this.groupTemplate == null) {
            try {
                ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader();
                Configuration cfg = Configuration.defaultConfiguration();
                this.groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
            }
            catch (IOException e) {
                log.error(e.toString());
            }
        }
        return this.groupTemplate;
    }

    @Override
    public String getName() {
        return "Beetl";
    }

    @Override
    public String render(String templatePath, Map<String, Object> data) throws Exception {
        GroupTemplate gt = this.getGroupTemplate();
        HashMap<String, Object> sharedVars = new HashMap<String, Object>();
        sharedVars.put("REQUEST", HttpContext.request());
        Session session = HttpContext.request().session();
        sharedVars.put("SESSION", session != null ? session.attributes() : new HashMap());
        gt.setSharedVars(sharedVars);
        Template template = gt.getTemplate(templatePath);
        template.binding(data);
        return template.render();
    }
}

