/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.server;

import com.fedepot.Razor;
import com.fedepot.exception.ExceptionHandler;
import com.fedepot.exception.RazorException;
import com.fedepot.ioc.IContainer;
import com.fedepot.mvc.controller.APIController;
import com.fedepot.mvc.controller.Controller;
import com.fedepot.mvc.http.ActionResult;
import com.fedepot.mvc.http.ContentType;
import com.fedepot.mvc.http.HttpContext;
import com.fedepot.mvc.http.HttpHeaderNames;
import com.fedepot.mvc.http.Request;
import com.fedepot.mvc.http.Response;
import com.fedepot.mvc.middleware.CookieParserMiddleware;
import com.fedepot.mvc.route.RouteSignature;
import com.fedepot.mvc.route.Router;
import com.fedepot.server.SessionHandler;
import com.fedepot.server.StaticFileHandler;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(HttpServerHandler.class);
    private Razor razor;
    private StaticFileHandler staticFileHandler;
    private SessionHandler sessionHandler;
    private ExceptionHandler exceptionHandler;
    private static final ExecutorService workerThreadService = HttpServerHandler.newBlockingExecutorUseCallerRun(Runtime.getRuntime().availableProcessors() * 2);

    private static ExecutorService newBlockingExecutorUseCallerRun(int size) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Razor-BlockingExecutor-pool-%d").build();
        return new ThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), threadFactory, (r, executor) -> {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    HttpServerHandler(Razor razor) {
        this.razor = razor;
        this.staticFileHandler = new StaticFileHandler(razor);
        this.sessionHandler = razor.getSessionManager() != null ? new SessionHandler(razor) : null;
        this.exceptionHandler = razor.getExceptionHandler();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)msg;
            workerThreadService.execute(() -> this.handleMessage(ctx, fullHttpRequest));
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((byte[])cause.getMessage().getBytes())));
        cause.printStackTrace();
        ctx.close();
        log.error(cause.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest) {
        Request request = Request.build(ctx, fullHttpRequest, this.sessionHandler);
        Response response = Response.build(ctx);
        HttpContext.set(new HttpContext(request, response));
        try {
            if (request.isStatic()) {
                this.staticFileHandler.handle(ctx, request, response);
                return;
            }
            new CookieParserMiddleware().apply(request, response);
            if (!request.method().equals("OPTIONS")) {
                request.session();
            }
            RouteSignature routeSignature = RouteSignature.builder().request(request).response(response).build();
            Router router = request.router();
            if (router != null) {
                routeSignature.setRouter(router);
                this.handleRoute(ctx, routeSignature);
            } else {
                response.notFound();
            }
        }
        catch (Exception e) {
            if (!response.flushed()) {
                response.interanlError();
            }
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(e, this.razor);
            } else {
                log.error("Handle inbound message failed", (Throwable)e);
            }
        }
        finally {
            if (!response.flushed()) {
                response.end();
            }
            HttpContext.remove();
        }
    }

    private void handleRoute(ChannelHandlerContext ctx, RouteSignature signature) throws Exception {
        Request request = signature.request();
        Response response = signature.response();
        this.applyMiddlewares(signature);
        if (request.method().equals("OPTIONS")) {
            if (!response.flushed()) {
                if (request.getOrigin() != null) {
                    response.sendStatus(405);
                } else {
                    response.sendStatus(200);
                }
            }
            return;
        }
        IContainer ioc = this.razor.getIoc();
        Class<?> controllerClass = signature.getRouter().getTargetType();
        Class<?> superClass = controllerClass.getSuperclass();
        if (superClass != Controller.class && superClass != APIController.class) {
            throw new RazorException(controllerClass.getName() + " is not a controller or api controller");
        }
        Class<?> controller = ioc.resolve(controllerClass);
        if (controller == null) {
            response.interanlError();
            return;
        }
        Method action = signature.getRouter().getAction();
        try {
            Object result;
            if (action.getParameterTypes().length == 0) {
                result = action.invoke(controller, new Object[0]);
            } else {
                Object[] args = signature.getParameters();
                result = action.invoke(controller, args);
            }
            Class<?> returnType = action.getReturnType();
            if (response.flushed()) {
                return;
            }
            if (returnType == Void.TYPE) {
                result = "";
            }
            if (response.get(HttpHeaderNames.CONTENT_TYPE) == null) {
                response.header(HttpHeaderNames.CONTENT_TYPE, ContentType.TEXT.getMimeTypeWithCharset());
            }
            response.end(ActionResult.build(result, returnType).getBytes(), (String[][])new String[0][]);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
    }

    private void applyMiddlewares(RouteSignature signature) {
        Router router = signature.getRouter();
        IContainer ioc = this.razor.getIoc();
        router.getMiddlewares().forEach(middleware -> {
            middleware = ioc.resolve(middleware);
            if (signature.response() == null || !signature.response().flushed()) {
                middleware.apply(signature.request(), signature.response());
            }
        });
    }
}

