/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.server;

import com.fedepot.Razor;
import com.fedepot.mvc.Constants;
import com.fedepot.server.HttpServerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.stream.ChunkedWriteHandler;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private Razor razor;

    HttpServerInitializer(Razor razor) {
        this.razor = razor;
    }

    public void initChannel(SocketChannel socketChannel) throws Exception {
        ChannelPipeline pl = socketChannel.pipeline();
        pl.addLast("codec", (ChannelHandler)new HttpServerCodec());
        if (this.razor.getEnv().getBool("razor.server.gzip", Constants.DEFAULT_GZIP_ENABLE).booleanValue()) {
            pl.addLast("gzip", (ChannelHandler)new HttpContentCompressor());
        }
        pl.addLast("continue", (ChannelHandler)new HttpServerExpectContinueHandler());
        pl.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(524288));
        pl.addLast("chunk", (ChannelHandler)new ChunkedWriteHandler());
        pl.addLast("request", (ChannelHandler)new HttpServerHandler(this.razor));
    }
}

