/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.server;

import com.fedepot.Razor;
import com.fedepot.env.Env;
import com.fedepot.mvc.Constants;
import com.fedepot.server.HttpServerHandler;
import com.fedepot.server.HttpServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    private Razor razor;
    private Env env;
    private Channel channel;
    private final NioEventLoopGroup masterGroup = new NioEventLoopGroup();
    private final NioEventLoopGroup slaveGroup = new NioEventLoopGroup();

    public void run(Razor razor, String[] args) throws Exception {
        this.razor = razor;
        this.env = razor.getEnv();
        this.startServer();
    }

    private void startServer() throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)this.masterGroup, (EventLoopGroup)this.slaveGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpServerInitializer(this.razor)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            this.channel = bootstrap.bind(this.env.get("razor.server.host", "0.0.0.0"), this.env.getInt("razor.server.port", Constants.DEFAULT_SERVER_PORT).intValue()).sync().channel();
            log.info("{} started and listen on {}", (Object)HttpServerHandler.class.getName(), (Object)this.channel.localAddress());
        }
        catch (InterruptedException e) {
            log.error("Netty server startup failed, error: {}", (Object)e.getMessage());
        }
    }

    public void shutdown() {
        this.slaveGroup.shutdownGracefully();
        this.masterGroup.shutdownGracefully();
        try {
            this.channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            log.error("Netty server shutdown failed, error: {}", (Object)e.getMessage());
        }
    }
}

