/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.server;

import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressiveFutureListener
implements ChannelProgressiveFutureListener {
    private static final Logger log = LoggerFactory.getLogger(ProgressiveFutureListener.class);
    private RandomAccessFile raf;

    public ProgressiveFutureListener(RandomAccessFile raf) {
        this.raf = raf;
    }

    public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) throws Exception {
        if (total < 0L) {
            log.debug("Channel {} transfer progress: {}", (Object)future.channel(), (Object)progress);
        } else {
            log.debug("Channel {} transfer progress: {}, total {}", new Object[]{future.channel(), progress, total});
        }
    }

    public void operationComplete(ChannelProgressiveFuture future) throws Exception {
        try {
            this.raf.close();
            log.debug("Channel {} transfer complete", (Object)future.channel());
        }
        catch (Exception e) {
            log.error("Close randomAccessFile with error", (Throwable)e);
        }
    }
}

