/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.server;

import com.fedepot.Razor;
import com.fedepot.env.Env;
import com.fedepot.mvc.Constants;
import com.fedepot.mvc.http.Cookie;
import com.fedepot.mvc.http.HttpContext;
import com.fedepot.mvc.http.HttpSession;
import com.fedepot.mvc.http.Request;
import com.fedepot.mvc.http.Response;
import com.fedepot.mvc.http.Session;
import com.fedepot.mvc.http.SessionManager;
import com.groupon.uuid.UUID;
import java.time.Instant;
import java.util.Optional;

public class SessionHandler {
    private final String sessionKey;
    private final int timeout;
    private SessionManager sessionManager;

    SessionHandler(Razor razor) {
        Env env = razor.getEnv();
        this.sessionKey = env.get("razor.web.http.session.key", "SESSION");
        this.timeout = env.getInt("razor.web.http.session.timeout", Constants.DEFAULT_SESSION_TIMEOUT);
        this.sessionManager = razor.getSessionManager();
    }

    public Session getSession(Request request) {
        Session session = null;
        Optional<String> sessionId = request.cookie(this.sessionKey);
        Response response = HttpContext.response();
        if (sessionId.isPresent()) {
            session = this.sessionManager.get(sessionId.get());
        }
        if (session != null) {
            if (session.expireAt() < Instant.now().getEpochSecond()) {
                this.removeSession(session, response);
            }
            return session;
        }
        return this.createSession(request, response);
    }

    private Session createSession(Request request, Response response) {
        String sessionId = new UUID().toString();
        long now = Instant.now().getEpochSecond();
        long expires = now + (long)this.timeout;
        HttpSession session = new HttpSession(sessionId, now, expires);
        this.sessionManager.add(session);
        Cookie cookie = Cookie.builder().name(this.sessionKey).value(sessionId).httpOnly(true).maxAge(this.timeout).build();
        request.cookie(cookie);
        response.cookie(cookie);
        return session;
    }

    private void removeSession(Session session, Response response) {
        session.attributes().clear();
        this.sessionManager.remove(session.id());
        response.cookie(Cookie.builder().name(session.id()).maxAge(-1L).build());
    }
}

