/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.server;

import com.fedepot.Razor;
import com.fedepot.env.Env;
import com.fedepot.exception.RazorException;
import com.fedepot.mvc.Constants;
import com.fedepot.mvc.http.ContentType;
import com.fedepot.mvc.http.HttpHeaderNames;
import com.fedepot.mvc.http.Request;
import com.fedepot.mvc.http.Response;
import com.fedepot.server.IRequestHandler;
import com.fedepot.util.DateKit;
import com.fedepot.util.MimeKit;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileHandler
implements IRequestHandler<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(StaticFileHandler.class);
    private Razor razor;

    StaticFileHandler(Razor razor) {
        this.razor = razor;
    }

    @Override
    public Boolean handle(ChannelHandlerContext ctx, Request request, Response response) throws RazorException {
        File file;
        boolean useOuterWebRootDir;
        if (!request.method().equals("GET")) {
            response.sendError(HttpResponseStatus.METHOD_NOT_ALLOWED);
            return false;
        }
        String path = request.path();
        Map<String, String> staticsMap = this.razor.getStaticsMap();
        for (String routePrefix : staticsMap.keySet()) {
            if (!path.startsWith(routePrefix)) continue;
            path = staticsMap.get(routePrefix).concat(path.substring(routePrefix.length()));
            break;
        }
        if (path.toUpperCase().startsWith("/WEB-INF")) {
            response.sendError(HttpResponseStatus.FORBIDDEN);
            return false;
        }
        if (path.contains("..") || path.contains(".".concat(File.separator)) || path.contains(File.separator.concat(".")) || path.charAt(0) == '.' || path.charAt(path.length() - 1) == '.') {
            response.sendError(HttpResponseStatus.NOT_FOUND);
            return false;
        }
        Env env = this.razor.getEnv();
        String webRoot = env.get("razor.runtime.web.root.path", "");
        String absPath = webRoot.concat(path);
        boolean bl = useOuterWebRootDir = env.getBool("razor.web.root.outer", false) != false && env.get("razor.web.root").isPresent();
        if (!useOuterWebRootDir) {
            URL url = this.getClass().getResource(File.separator.concat(env.get("razor.web.root", "WWW")).concat(path));
            if (url == null) {
                response.sendError(HttpResponseStatus.NOT_FOUND);
                return false;
            }
            if (url.toString().startsWith("file:/") || url.toString().startsWith("jar:file:/")) {
                File tmpFile = new File(Constants.ROOT_DIR.concat(File.separator).concat("cache").concat(path));
                if (!tmpFile.exists()) {
                    try {
                        InputStream openStream = url.openStream();
                        int contentLength = openStream.available();
                        byte[] binaryData = new byte[contentLength];
                        openStream.read(binaryData);
                        FileUtils.copyURLToFile((URL)url, (File)tmpFile);
                        this.setHeaders(tmpFile, request, response);
                        response.end(binaryData, (String[][])new String[0][]);
                        openStream.close();
                        return true;
                    }
                    catch (Exception e) {
                        response.interanlError();
                        return false;
                    }
                }
                absPath = tmpFile.getAbsolutePath();
            }
        }
        if (!(file = new File(absPath)).exists() || file.isHidden()) {
            response.sendError(HttpResponseStatus.NOT_FOUND);
            return false;
        }
        if (!file.isFile() && !file.isDirectory()) {
            response.sendError(HttpResponseStatus.FORBIDDEN);
            return false;
        }
        if (file.isDirectory()) {
            HashSet<String> indexs = new HashSet<String>(env.getObject("razor.web.indexs").orElse(Constants.DEFAULT_INDEX_FILES));
            File indexFile = null;
            for (String index : indexs) {
                String filePath = absPath.endsWith(File.separator) ? absPath.concat(index) : absPath.concat(File.separator).concat(index);
                File tmpFile = new File(filePath);
                if (!tmpFile.exists() || !tmpFile.isFile() || tmpFile.isHidden()) continue;
                indexFile = tmpFile;
                break;
            }
            if (indexFile == null) {
                response.sendError(HttpResponseStatus.NOT_FOUND);
                return false;
            }
            file = indexFile;
        }
        if (this.checkCache(file, request, response)) {
            return false;
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            long length = raf.length();
            this.setHeaders(file, request, response);
            response.sendFile(raf, length);
            return true;
        }
        catch (FileNotFoundException e) {
            log.error("Static file not found: {}", (Object)file.getPath());
            response.sendError(HttpResponseStatus.NOT_FOUND);
            throw new RazorException(e);
        }
        catch (IOException e) {
            log.error("Static file IO exception: {}", (Object)file.getPath());
            response.sendError(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            throw new RazorException(e);
        }
    }

    private boolean checkCache(File file, Request request, Response response) {
        String ifMdf = request.get(HttpHeaderNames.IF_MODIFIED_SINCE);
        String cacheControl = request.get(HttpHeaderNames.CACHE_CONTROL);
        if (ifMdf == null || ifMdf.isEmpty() || Arrays.asList("max-age=0", "no-cache", "no-store").contains(cacheControl.toLowerCase())) {
            return false;
        }
        Date ifMdfSinceDate = DateKit.dateFromGmt(ifMdf);
        long ifMdfSinceSecs = ifMdfSinceDate.getTime() / 1000L;
        long fileLastMdfSecs = file.lastModified() / 1000L;
        if (fileLastMdfSecs < 0L && ifMdfSinceSecs <= Instant.now().getEpochSecond() || fileLastMdfSecs == ifMdfSinceSecs) {
            response.status(304).end();
            return true;
        }
        return false;
    }

    private void setHeaders(File file, Request request, Response response) {
        String filename = file.getName();
        response.setDate();
        ContentType contentType = MimeKit.detailOf(filename);
        response.header(HttpHeaderNames.CONTENT_TYPE, contentType.getMimeType());
        String disposition = contentType.isInline() ? "inline" : "attachment;filename=".concat(filename);
        response.header(HttpHeaderNames.CONTENT_DISPOSITION, disposition);
        int cacheSeconds = this.razor.getEnv().getInt("razor.web.http.cache.seconds", Constants.DEFAULT_HTTP_CACHE_SECONDS);
        LocalDateTime expireDateTime = LocalDateTime.now().plusSeconds(cacheSeconds);
        response.header(HttpHeaderNames.EXPIRES, DateKit.getGmtDateString(expireDateTime));
        response.header(HttpHeaderNames.CACHE_CONTROL, "private, max-age=" + cacheSeconds);
        String lastMdf = file != null ? DateKit.getGmtDateString(new Date(file.lastModified())) : DateKit.getGmtDateString();
        response.header(HttpHeaderNames.LAST_MODIFIED, lastMdf);
        if (request.keepAlive()) {
            response.header(HttpHeaderNames.CONNECTION, "keep-alive");
        }
    }
}

