/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.util;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

public class DateKit {
    public static Date dateFromGmt(String dateString) {
        return DateKit.dateFromString(dateString, "EEE, dd MMM yyyy HH:mm:ss zzz");
    }

    public static Date dateFromString(String dateString, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.US);
        LocalDateTime formatted = LocalDateTime.parse(dateString, formatter);
        return Date.from(formatted.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String getGmtDateString() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        return formatter.format(LocalDateTime.now().atZone(ZoneId.of("GMT")));
    }

    public static String getGmtDateString(Date date) {
        return DateKit.getZoneDateString(date, "EEE, dd MMM yyyy HH:mm:ss zzz", ZoneId.of("GMT"));
    }

    public static String getGmtDateString(LocalDateTime date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        return formatter.format(date.atZone(ZoneId.of("GMT")));
    }

    public static String getDateString(Date date, String pattern) {
        return DateKit.getZoneDateString(date, pattern, ZoneId.systemDefault());
    }

    public static String getZoneDateString(Date date, String pattern, ZoneId zoneId) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.US);
        return formatter.format(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).atZone(zoneId));
    }
}

