/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.util;

import com.fedepot.exception.NotImplementException;
import com.fedepot.mvc.http.ContentType;
import java.io.File;
import java.io.InputStream;

public class MimeKit {
    public static String get(String extOrMime) {
        ContentType type = ContentType.fromMimeType(extOrMime = extOrMime.toLowerCase());
        if (type != ContentType.EMPTY) {
            return type.getMimeType();
        }
        if (extOrMime.startsWith(".")) {
            extOrMime = extOrMime.substring(1);
        }
        return MimeKit.ofExt(extOrMime);
    }

    public static String of(String name) {
        ContentType type = ContentType.fromFileExtension(name = name.toLowerCase());
        if (type != ContentType.EMPTY) {
            return type.getMimeType();
        }
        int index = name.lastIndexOf(46);
        if (index < 0 || index == name.length() - 1) {
            return null;
        }
        return MimeKit.ofExt(name.substring(index + 1));
    }

    public static ContentType detailOf(String name) {
        ContentType type = ContentType.fromFileExtension(name = name.toLowerCase());
        if (type != ContentType.EMPTY) {
            return type;
        }
        int index = name.lastIndexOf(46);
        if (index < 0 || index == name.length() - 1) {
            return null;
        }
        return MimeKit.detailOfExt(name.substring(index + 1));
    }

    public static String ofExt(String ext) {
        ContentType type = ContentType.fromFileExtension(ext);
        if (type == ContentType.EMPTY) {
            return null;
        }
        return type.getMimeType();
    }

    public static ContentType detailOfExt(String ext) {
        ContentType type = ContentType.fromFileExtension(ext);
        if (type == ContentType.EMPTY) {
            return null;
        }
        return type;
    }

    public static String ofStream(InputStream stream) {
        throw new NotImplementException();
    }

    public static String ofFile(File file) {
        throw new NotImplementException();
    }
}

