/*
 * Decompiled with CFR 0.152.
 */
package com.feedhenry.sdk.tests.api2;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.test.ActivityInstrumentationTestCase2;
import com.feedhenry.sdk.FHActCallback;
import com.feedhenry.sdk.FHResponse;
import com.feedhenry.sdk.api.FHAuthRequest;
import com.feedhenry.sdk.api2.FHAuthSession;
import com.feedhenry.sdk.tests.MainActivity;
import com.feedhenry.sdk.tests.sync.FHTestUtils;
import com.feedhenry.sdk.utils.DataManager;
import com.feedhenry.sdk2.FHHttpClient;
import cz.msebera.android.httpclient.Header;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.fh.JSONObject;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class FHAuthRequestTest
extends ActivityInstrumentationTestCase2 {
    private FHAuthSession fhAuthSession;
    private Context mContext;
    private DataManager mDataManager;

    public FHAuthRequestTest() {
        super(MainActivity.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.mContext = this.getActivity().getApplicationContext();
        System.setProperty("dexmaker.dexcache", this.mContext.getCacheDir().getPath());
        this.mDataManager = DataManager.init((Context)this.mContext);
        if (this.mDataManager.read("sessionToken") != null) {
            this.mDataManager.remove("sessionToken");
        }
        this.fhAuthSession = new FHAuthSession(this.mDataManager, new FHHttpClient());
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.mDataManager != null) {
            this.mDataManager.remove("sessionToken");
        }
    }

    public void testSuccessfulFHAuthRequestCreatesSessionToken() throws Exception {
        FHAuthRequest authRequest = new FHAuthRequest(this.mContext, this.fhAuthSession);
        authRequest.setPresentingActivity((Context)this.getActivity());
        authRequest.setAuthUser("testAuthPolicy", "test", "test");
        FHHttpClient mockClient = (FHHttpClient)Mockito.mock(FHHttpClient.class);
        ((FHHttpClient)Mockito.doAnswer((Answer)this.callSuccess()).when((Object)mockClient)).post((String)Matchers.any(String.class), (Header[])Matchers.any(Header[].class), (JSONObject)Matchers.any(JSONObject.class), (FHActCallback)Matchers.any(FHActCallback.class), Matchers.anyBoolean());
        final AtomicBoolean success = new AtomicBoolean(false);
        FHTestUtils.injectInto(authRequest, mockClient);
        authRequest.execute(new FHActCallback(){

            public void success(FHResponse pResponse) {
                success.set(true);
            }

            public void fail(FHResponse pResponse) {
            }
        });
        FHAuthRequestTest.assertTrue((boolean)this.fhAuthSession.exists());
        FHAuthRequestTest.assertTrue((boolean)success.get());
        FHAuthRequestTest.assertEquals((String)"testToken", (String)this.mDataManager.read("sessionToken"));
    }

    public void testFailingFHAuthRequestCallsFail() throws Exception {
        FHAuthRequest authRequest = new FHAuthRequest(this.mContext, this.fhAuthSession);
        authRequest.setPresentingActivity((Context)this.getActivity());
        authRequest.setAuthUser("testAuthPolicy", "test", "test");
        FHHttpClient mockClient = (FHHttpClient)Mockito.mock(FHHttpClient.class);
        ((FHHttpClient)Mockito.doAnswer((Answer)this.callFailure()).when((Object)mockClient)).post((String)Matchers.any(String.class), (Header[])Matchers.any(Header[].class), (JSONObject)Matchers.any(JSONObject.class), (FHActCallback)Matchers.any(FHActCallback.class), Matchers.anyBoolean());
        final AtomicBoolean success = new AtomicBoolean(false);
        FHTestUtils.injectInto(authRequest, mockClient);
        authRequest.execute(new FHActCallback(){

            public void success(FHResponse pResponse) {
                success.set(true);
            }

            public void fail(FHResponse pResponse) {
                success.set(false);
            }
        });
        FHAuthRequestTest.assertFalse((boolean)this.fhAuthSession.exists());
        FHAuthRequestTest.assertFalse((boolean)success.get());
    }

    public void testOnReceiveLogsInOAuthRequestWhenSuccessIsFollowedByAHash() {
        String googleResponse = "https://testing.feedhenry.me/box/srv/1.1/arm/authCallback?fh_auth_session=j6wnpwpb2xjn2a7quutrxubz&authResponse={\"authToken\":\"testToken\",\"email\":\"TestEmail\",\"family_name\":\"Henry\",\"gender\":\"male\",\"given_name\":\"Feed\",\"hd\":\"feedhenry.com\",\"id\":\"8675309\",\"link\":\"https://plus.google.com/8675309\",\"name\":\"Feed Henry\",\"picture\":\"http://www.feedhenry.com/wp-content/uploads/2015/01/fh-rh-top-logo-sm.png\",\"verified_email\":true}&status=complete&result=success#";
        FHAuthRequest authRequest = new FHAuthRequest(this.mContext, this.fhAuthSession);
        final AtomicBoolean success = new AtomicBoolean(false);
        FHActCallback callback = new FHActCallback(){

            public void success(FHResponse pResponse) {
                success.set(true);
            }

            public void fail(FHResponse pResponse) {
            }
        };
        authRequest.setPresentingActivity((Context)Mockito.mock(MainActivity.class));
        BroadcastReceiver oauth2Receiver = (BroadcastReceiver)FHTestUtils.instanciatePrivateInnerClass("OAuthURLRedirectReceiver", authRequest, callback);
        oauth2Receiver.onReceive(null, new Intent().putExtra("url", "https://testing.feedhenry.me/box/srv/1.1/arm/authCallback?fh_auth_session=j6wnpwpb2xjn2a7quutrxubz&authResponse={\"authToken\":\"testToken\",\"email\":\"TestEmail\",\"family_name\":\"Henry\",\"gender\":\"male\",\"given_name\":\"Feed\",\"hd\":\"feedhenry.com\",\"id\":\"8675309\",\"link\":\"https://plus.google.com/8675309\",\"name\":\"Feed Henry\",\"picture\":\"http://www.feedhenry.com/wp-content/uploads/2015/01/fh-rh-top-logo-sm.png\",\"verified_email\":true}&status=complete&result=success#"));
        FHAuthRequestTest.assertTrue((boolean)success.get());
    }

    private Answer callSuccess() {
        return new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                FHActCallback callback = (FHActCallback)args[3];
                callback.success(FHAuthRequestTest.this.successResponse());
                return null;
            }
        };
    }

    private Answer callFailure() {
        return new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                FHActCallback callback = (FHActCallback)args[3];
                callback.fail(FHAuthRequestTest.this.successResponse());
                return null;
            }
        };
    }

    private FHResponse successResponse() {
        JSONObject successJSON = new JSONObject("{\"status\":\"ok\", \"sessionToken\":\"testToken\"}");
        return new FHResponse(successJSON, null, null, null);
    }
}

