/*
 * Decompiled with CFR 0.152.
 */
package com.feedhenry.sdk.tests.api2;

import android.content.Context;
import android.test.AndroidTestCase;
import android.util.Log;
import com.feedhenry.sdk.FHActCallback;
import com.feedhenry.sdk.FHResponse;
import com.feedhenry.sdk.api.FHAuthSession;
import com.feedhenry.sdk.api2.FHAuthSession;
import com.feedhenry.sdk.utils.DataManager;
import com.feedhenry.sdk2.FHHttpClient;
import cz.msebera.android.httpclient.Header;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.fh.JSONObject;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class FHAuthSessionTest
extends AndroidTestCase {
    private static final String TEST_TOKEN = "testSessionToken";
    private DataManager mDataManager;
    private FHAuthSession session;
    private FHHttpClient mFHHttpClient;

    public void setUp() throws Exception {
        this.mDataManager = DataManager.init((Context)this.getContext());
        this.mDataManager.save("sessionToken", TEST_TOKEN);
        this.mFHHttpClient = (FHHttpClient)Mockito.mock(FHHttpClient.class);
        this.session = new FHAuthSession(this.mDataManager, this.mFHHttpClient);
    }

    public void tearDown() throws Exception {
        if (this.mDataManager != null) {
            this.mDataManager.remove("sessionToken");
        }
    }

    public void testExists() throws Exception {
        FHAuthSessionTest.assertTrue((boolean)this.session.exists());
    }

    public void testVerify() throws Exception {
        final AtomicBoolean valid = new AtomicBoolean(false);
        ((FHHttpClient)Mockito.doAnswer((Answer)this.verifyTrue()).when((Object)this.mFHHttpClient)).post(Matchers.matches((String)"http://localhost:9000/box/srv/1.1/admin/authpolicy/verifysession"), (Header[])Matchers.any(Header[].class), (JSONObject)Matchers.eq((Object)new JSONObject().put("sessionToken", (Object)TEST_TOKEN)), (FHActCallback)Matchers.any(FHActCallback.class), Matchers.eq((boolean)true));
        this.session.verify(new FHAuthSession.Callback(){
            private String TAG = "Callback";

            public void handleSuccess(boolean isValid) {
                valid.set(true);
            }

            public void handleError(FHResponse pRes) {
                Log.e((String)this.TAG, (String)pRes.getErrorMessage());
            }
        }, true);
        ((FHHttpClient)Mockito.verify((Object)this.mFHHttpClient)).post(Matchers.matches((String)"http://localhost:9000/box/srv/1.1/admin/authpolicy/verifysession"), (Header[])Matchers.any(Header[].class), (JSONObject)Matchers.eq((Object)new JSONObject().put("sessionToken", (Object)TEST_TOKEN)), (FHActCallback)Matchers.any(FHActCallback.class), Matchers.eq((boolean)true));
        FHAuthSessionTest.assertTrue((boolean)valid.get());
        FHAuthSessionTest.assertEquals((String)TEST_TOKEN, (String)this.session.getToken());
    }

    public void testClear() throws Exception {
        ((FHHttpClient)Mockito.doAnswer((Answer)this.verifyTrue()).when((Object)this.mFHHttpClient)).post(Matchers.matches((String)"http://localhost:9000/box/srv/1.1/admin/authpolicy/revokesession"), (Header[])Matchers.any(Header[].class), (JSONObject)Matchers.eq((Object)new JSONObject().put("sessionToken", (Object)TEST_TOKEN)), (FHActCallback)Matchers.any(FHActCallback.class), Matchers.eq((boolean)true));
        this.session.clear(true);
        FHAuthSessionTest.assertFalse((boolean)this.session.exists());
        ((FHHttpClient)Mockito.verify((Object)this.mFHHttpClient)).post(Matchers.matches((String)"http://localhost:9000/box/srv/1.1/admin/authpolicy/revokesession"), (Header[])Matchers.any(Header[].class), (JSONObject)Matchers.eq((Object)new JSONObject().put("sessionToken", (Object)TEST_TOKEN)), (FHActCallback)Matchers.any(FHActCallback.class), Matchers.eq((boolean)true));
    }

    private Answer verifyTrue() {
        return new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                FHActCallback callback = (FHActCallback)invocation.getArguments()[3];
                callback.success(FHAuthSessionTest.this.successResponse());
                return null;
            }
        };
    }

    private FHResponse successResponse() {
        JSONObject successJSON = new JSONObject("{\"status\":\"ok\", \"isValid\":true}");
        return new FHResponse(successJSON, null, null, null);
    }
}

