/*
 * Decompiled with CFR 0.152.
 */
package com.feedhenry.sdk.tests.sync;

import android.content.Context;
import android.test.ActivityInstrumentationTestCase2;
import com.feedhenry.sdk.FH;
import com.feedhenry.sdk.sync.FHSyncClient;
import com.feedhenry.sdk.sync.FHSyncConfig;
import com.feedhenry.sdk.sync.FHSyncDataset;
import com.feedhenry.sdk.sync.FHSyncListener;
import com.feedhenry.sdk.tests.MainActivity;
import com.feedhenry.sdk.tests.sync.FHTestUtils;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.fh.JSONObject;
import org.mockito.Mockito;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.verification.VerificationMode;

public class FHSyncDatasetTest
extends ActivityInstrumentationTestCase2 {
    private static final String DATASET_ID = "testDataSet";
    private MockWebServer mockWebServer;

    public FHSyncDatasetTest() {
        super(MainActivity.class);
    }

    public void setUp() throws Exception {
        this.mockWebServer = new MockWebServer();
        this.mockWebServer.start(9100);
        System.setProperty("dexmaker.dexcache", this.getActivity().getCacheDir().getPath());
        FH.init((Context)this.getActivity(), null);
    }

    public void tearDown() throws Exception {
        this.mockWebServer.shutdown();
        Thread.sleep(100L);
    }

    public void testDataSetStopSyncStopsSync() throws Exception {
        this.mockWebServer.enqueue(new MockResponse().setBody("{}"));
        FHSyncListener listener = (FHSyncListener)Mockito.mock(FHSyncListener.class);
        FHSyncConfig config = new FHSyncConfig();
        config.setNotifySyncComplete(true);
        config.setSyncFrequency(1);
        FHSyncClient client = new FHSyncClient();
        client.init((Context)this.getActivity(), config, listener);
        client.manage(DATASET_ID, null, new JSONObject());
        Map datasets = (Map)FHTestUtils.getPrivateField(client, "mDataSets");
        FHSyncDataset dataset = (FHSyncDataset)datasets.get(DATASET_ID);
        FHSyncDataset spy = (FHSyncDataset)Mockito.spy((Object)dataset);
        ((FHSyncDataset)Mockito.doNothing().when((Object)spy)).startSyncLoop();
        ((FHSyncDataset)Mockito.doReturn((Object)false).when((Object)spy)).isSyncRunning();
        ((FHSyncDataset)Mockito.doReturn((Object)true).when((Object)spy)).isSyncPending();
        ((FHSyncDataset)Mockito.doReturn(null).when((Object)spy)).getSyncStart();
        datasets.put(DATASET_ID, spy);
        AtomicInteger invocations = new AtomicInteger(0);
        int runningInvocations = 0;
        Thread.sleep(1500L);
        ((FHSyncDataset)Mockito.verify((Object)spy, (VerificationMode)this.countAtleast(invocations, 1))).startSyncLoop();
        runningInvocations = invocations.get();
        client.pauseSync();
        Thread.sleep(2000L);
        ((FHSyncDataset)Mockito.verify((Object)spy, (VerificationMode)this.countExactly(invocations, runningInvocations))).startSyncLoop();
        client.resumeSync(listener);
        Thread.sleep(2000L);
        ((FHSyncDataset)Mockito.verify((Object)spy, (VerificationMode)this.countAtleast(invocations, runningInvocations + 1))).startSyncLoop();
    }

    private VerificationMode countAtleast(final AtomicInteger invocationsOut, final int numberOfInvocations) {
        return new VerificationMode(){

            public void verify(VerificationData data) {
                InvocationMatcher wanted;
                List invocations = data.getAllInvocations();
                int actualInvocations = new InvocationsFinder().findInvocations(invocations, wanted = data.getWanted()).size();
                if (actualInvocations < numberOfInvocations) {
                    throw new IllegalStateException("Found " + actualInvocations + " but wanted " + numberOfInvocations);
                }
                invocationsOut.set(actualInvocations);
            }
        };
    }

    private VerificationMode countExactly(final AtomicInteger invocationsOut, final int numberOfInvocations) {
        return new VerificationMode(){

            public void verify(VerificationData data) {
                InvocationMatcher wanted;
                List invocations = data.getAllInvocations();
                int actualInvocations = new InvocationsFinder().findInvocations(invocations, wanted = data.getWanted()).size();
                if (actualInvocations != numberOfInvocations) {
                    throw new IllegalStateException("Found " + actualInvocations + " but wanted " + numberOfInvocations);
                }
                invocationsOut.set(actualInvocations);
            }
        };
    }
}

