/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.data.schema;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractValueSchema
implements Serializable {
    public static final String MISSING_VALUE = null;
    private static final long serialVersionUID = 4963437183478456079L;
    private final boolean allowMissing;

    protected AbstractValueSchema(boolean allowMissing) {
        this.allowMissing = allowMissing;
    }

    public boolean isAllowMissing() {
        return this.allowMissing;
    }

    public boolean validate(String value) {
        return !StringUtils.equals((CharSequence)value, (CharSequence)MISSING_VALUE) || this.allowMissing;
    }

    public int hashCode() {
        return Objects.hash(this.allowMissing);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractValueSchema other = (AbstractValueSchema)obj;
        return Objects.equals(this.allowMissing, other.allowMissing);
    }

    public final String toString() {
        return this.toStringHelper().toString();
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("allowMissing", this.allowMissing);
    }
}

