/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.data.schema;

import com.feedzai.openml.data.schema.AbstractValueSchema;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;

public class CategoricalValueSchema
extends AbstractValueSchema {
    private static final long serialVersionUID = 6725548314380017998L;
    private final SortedSet<String> nominalValues;

    public CategoricalValueSchema(boolean allowMissing, Set<String> nominalValues) {
        super(allowMissing);
        Preconditions.checkNotNull(nominalValues, (Object)"nominal values should not be null");
        this.nominalValues = ImmutableSortedSet.copyOf(nominalValues);
    }

    public SortedSet<String> getNominalValues() {
        return this.nominalValues;
    }

    @Override
    public boolean validate(String value) {
        return super.validate(value) && (value == null || this.nominalValues.contains(value));
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.nominalValues);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CategoricalValueSchema other = (CategoricalValueSchema)obj;
        return Objects.equals(this.nominalValues, other.nominalValues);
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("nominalValues", this.nominalValues);
    }
}

