/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.data.schema;

import com.feedzai.openml.data.schema.FieldSchema;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DatasetSchema
implements Serializable {
    private static final long serialVersionUID = -6508738272056130831L;
    private final int targetIndex;
    private final List<FieldSchema> fieldSchemas;

    public DatasetSchema(int targetIndex, List<FieldSchema> fieldSchemas) {
        this.fieldSchemas = this.checkFieldSchemas(fieldSchemas);
        this.targetIndex = targetIndex >= 0 ? Preconditions.checkElementIndex((int)targetIndex, (int)fieldSchemas.size(), (String)"target index should be a valid index") : targetIndex;
    }

    public DatasetSchema(List<FieldSchema> fieldSchemas) {
        this(-1, fieldSchemas);
    }

    private List<FieldSchema> checkFieldSchemas(List<FieldSchema> fieldSchemas) {
        Preconditions.checkNotNull(fieldSchemas, (Object)"field schemas should not be null");
        List indexes = fieldSchemas.stream().map(FieldSchema::getFieldIndex).collect(Collectors.toList());
        Preconditions.checkArgument((boolean)indexes.equals(IntStream.range(0, indexes.size()).boxed().collect(Collectors.toList())), (Object)"schema fields must be sorted by increasing index, with no duplicated nor missing index elements");
        Preconditions.checkArgument((fieldSchemas.size() == fieldSchemas.stream().map(FieldSchema::getFieldName).collect(Collectors.toSet()).size() ? 1 : 0) != 0, (Object)"field schemas should have unique names");
        return ImmutableList.copyOf(fieldSchemas);
    }

    public Optional<Integer> getTargetIndex() {
        return this.targetIndex < 0 ? Optional.empty() : Optional.of(this.targetIndex);
    }

    public List<FieldSchema> getFieldSchemas() {
        return ImmutableList.copyOf(this.fieldSchemas);
    }

    public Optional<FieldSchema> getTargetFieldSchema() {
        return this.getTargetIndex().map(this.fieldSchemas::get);
    }

    public List<FieldSchema> getPredictiveFields() {
        Optional<Integer> targetIndex = this.getTargetIndex();
        if (!targetIndex.isPresent()) {
            return this.fieldSchemas;
        }
        return this.fieldSchemas.stream().filter(field -> field.getFieldIndex() != ((Integer)targetIndex.get()).intValue()).collect(Collectors.toList());
    }

    public int hashCode() {
        return Objects.hash(this.targetIndex, this.fieldSchemas);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DatasetSchema other = (DatasetSchema)obj;
        return Objects.equals(this.targetIndex, other.targetIndex) && Objects.equals(this.fieldSchemas, other.fieldSchemas);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("targetIndex", this.targetIndex).add("fieldSchemas", this.fieldSchemas).toString();
    }
}

