/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.data.schema;

import com.feedzai.openml.data.schema.AbstractValueSchema;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class FieldSchema
implements Serializable {
    private static final long serialVersionUID = -326775681858303214L;
    private final String fieldName;
    private final int fieldIndex;
    private final AbstractValueSchema valueSchema;

    public FieldSchema(String fieldName, int fieldIndex, AbstractValueSchema valueSchema) {
        Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (Object)"field index should be non negative nor empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fieldName), (Object)"field name should not be null  nor empty");
        Preconditions.checkNotNull((Object)valueSchema, (Object)"valueSchema should not be null");
        this.fieldIndex = fieldIndex;
        this.fieldName = fieldName;
        this.valueSchema = valueSchema;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public AbstractValueSchema getValueSchema() {
        return this.valueSchema;
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.fieldIndex, this.valueSchema);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSchema other = (FieldSchema)obj;
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.fieldIndex, other.fieldIndex) && Objects.equals(this.valueSchema, other.valueSchema);
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fieldName", (Object)this.fieldName).add("fieldIndex", this.fieldIndex).add("valueSchema", (Object)this.valueSchema).toString();
    }
}

