/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.provider.descriptor;

import com.feedzai.openml.provider.descriptor.MachineLearningAlgorithmType;
import com.feedzai.openml.provider.descriptor.ModelParameter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Objects;
import java.util.Set;

public class MLAlgorithmDescriptor {
    private final String algorithmName;
    private final Set<ModelParameter> parameters;
    private final MachineLearningAlgorithmType algorithmType;
    private final URL documentation;

    public MLAlgorithmDescriptor(String algorithmName, Set<ModelParameter> parameters, MachineLearningAlgorithmType algorithmType, URL documentation) {
        this.algorithmName = (String)Preconditions.checkNotNull((Object)algorithmName, (Object)"Algorithm name cannot be null");
        this.parameters = (Set)Preconditions.checkNotNull(parameters, (Object)"parameters cannot be null");
        this.algorithmType = (MachineLearningAlgorithmType)((Object)Preconditions.checkNotNull((Object)((Object)algorithmType), (Object)"algorithmType cannot be null"));
        this.documentation = (URL)Preconditions.checkNotNull((Object)documentation, (Object)"documentation cannot be null");
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public Set<ModelParameter> getParameters() {
        return this.parameters;
    }

    public MachineLearningAlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }

    public URL getDocumentation() {
        return this.documentation;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithmName, this.parameters, this.algorithmType, this.documentation});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MLAlgorithmDescriptor other = (MLAlgorithmDescriptor)obj;
        return Objects.equals(this.algorithmName, other.algorithmName) && Objects.equals(this.parameters, other.parameters) && Objects.equals((Object)this.algorithmType, (Object)other.algorithmType) && Objects.equals(this.documentation, other.documentation);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("algorithmName", (Object)this.algorithmName).add("parameters", this.parameters).add("algorithmType", (Object)this.algorithmType).add("documentation", (Object)this.documentation).toString();
    }
}

