/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.provider.descriptor;

import com.feedzai.openml.provider.descriptor.fieldtype.ModelParameterType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class ModelParameter {
    private final String name;
    private final String description;
    private final String helperDescription;
    private final boolean isMandatory;
    private final ModelParameterType fieldType;

    public ModelParameter(String name, String description, String helperDescription, boolean isMandatory, ModelParameterType fieldType) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description cannot be null");
        this.helperDescription = (String)Preconditions.checkNotNull((Object)helperDescription, (Object)"helper description cannot be null");
        this.isMandatory = isMandatory;
        this.fieldType = (ModelParameterType)Preconditions.checkNotNull((Object)fieldType, (Object)"field type cannot be null");
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHelperDescription() {
        return this.helperDescription;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public ModelParameterType getFieldType() {
        return this.fieldType;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.helperDescription, this.isMandatory, this.fieldType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ModelParameter other = (ModelParameter)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.helperDescription, other.helperDescription) && Objects.equals(this.isMandatory, other.isMandatory) && Objects.equals(this.fieldType, other.fieldType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("description", (Object)this.description).add("helperDescription", (Object)this.helperDescription).add("isMandatory", this.isMandatory).add("fieldType", (Object)this.fieldType).toString();
    }
}

