/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.provider.descriptor.fieldtype;

import com.feedzai.openml.provider.descriptor.fieldtype.ModelParameterType;
import com.feedzai.openml.provider.descriptor.fieldtype.ParamValidationError;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class BooleanFieldType
implements ModelParameterType {
    private final boolean defaultTrue;

    public BooleanFieldType(boolean defaultTrue) {
        this.defaultTrue = defaultTrue;
    }

    public boolean isDefaultTrue() {
        return this.defaultTrue;
    }

    @Override
    public Optional<ParamValidationError> validate(String parameterName, String parameterValue) {
        if (null == parameterValue) {
            return Optional.of(new ParamValidationError(parameterName, parameterValue, "should not be null"));
        }
        if (parameterValue.equalsIgnoreCase("true") || parameterValue.equalsIgnoreCase("false")) {
            return Optional.empty();
        }
        return Optional.of(new ParamValidationError(parameterName, parameterValue, "is not a valid boolean value"));
    }

    public int hashCode() {
        return Objects.hash(this.defaultTrue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanFieldType other = (BooleanFieldType)obj;
        return Objects.equals(this.defaultTrue, other.defaultTrue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("defaultTrue", this.defaultTrue).toString();
    }
}

