/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.provider.descriptor.fieldtype;

import com.feedzai.openml.provider.descriptor.fieldtype.ModelParameterType;
import com.feedzai.openml.provider.descriptor.fieldtype.ParamValidationError;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ChoiceFieldType
implements ModelParameterType {
    private final Set<String> allowedValues;
    private final String defaultValue;

    public ChoiceFieldType(Set<String> allowedValues, String defaultValue) {
        Preconditions.checkNotNull(allowedValues, (Object)"allowedValues can't be null.");
        Preconditions.checkArgument((!allowedValues.isEmpty() ? 1 : 0) != 0, (Object)"allowedValues can't be empty.");
        Preconditions.checkNotNull((Object)defaultValue, (Object)"defaultValue can't be null.");
        Preconditions.checkArgument((boolean)allowedValues.contains(defaultValue));
        this.defaultValue = defaultValue;
        this.allowedValues = ImmutableSet.copyOf(allowedValues);
    }

    public Set<String> getAllowedValues() {
        return this.allowedValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Optional<ParamValidationError> validate(String parameterName, String parameterValue) {
        if (this.allowedValues.contains(parameterValue)) {
            return Optional.empty();
        }
        String reason = "should be one of: " + String.join((CharSequence)", ", this.allowedValues);
        return Optional.of(new ParamValidationError(parameterName, parameterValue, reason));
    }

    public int hashCode() {
        return Objects.hash(this.allowedValues, this.defaultValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChoiceFieldType other = (ChoiceFieldType)obj;
        return Objects.equals(this.allowedValues, other.allowedValues) && Objects.equals(this.defaultValue, other.defaultValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("allowedValues", this.allowedValues).add("defaultValue", (Object)this.defaultValue).toString();
    }
}

