/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.provider.descriptor.fieldtype;

import com.feedzai.openml.provider.descriptor.fieldtype.ModelParameterType;
import com.feedzai.openml.provider.descriptor.fieldtype.ParamValidationError;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class NumericFieldType
implements ModelParameterType {
    private final double minValue;
    private final double maxValue;
    private final double defaultValue;
    private final ParameterConfigType parameterType;

    private NumericFieldType(double minValue, double maxValue, ParameterConfigType parameterType, double defaultValue) {
        Preconditions.checkArgument((minValue <= maxValue ? 1 : 0) != 0, (Object)"min value should be smaller or equal to max value");
        Preconditions.checkArgument((defaultValue >= minValue && defaultValue <= maxValue ? 1 : 0) != 0, (Object)"The default value must be within the min and max values.");
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.parameterType = (ParameterConfigType)((Object)Preconditions.checkNotNull((Object)((Object)parameterType), (Object)"Parameter type can't be null"));
        this.defaultValue = defaultValue;
    }

    public static NumericFieldType min(double minValue, ParameterConfigType parameterType, double defaultValue) {
        return NumericFieldType.range(minValue, Double.MAX_VALUE, parameterType, defaultValue);
    }

    public static NumericFieldType max(double maxValue, ParameterConfigType parameterType, double defaultValue) {
        return NumericFieldType.range(-1.7976931348623157E308, maxValue, parameterType, defaultValue);
    }

    public static NumericFieldType range(double minValue, double maxValue, ParameterConfigType parameterType, double defaultValue) {
        return new NumericFieldType(minValue, maxValue, parameterType, defaultValue);
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public ParameterConfigType getParameterType() {
        return this.parameterType;
    }

    @Override
    public Optional<ParamValidationError> validate(String parameterName, String parameterValue) {
        if (null == parameterValue) {
            return Optional.of(new ParamValidationError(parameterName, parameterValue, "parameter value can't be null."));
        }
        try {
            double parsedValue = Double.parseDouble(parameterValue);
            if (parsedValue < this.minValue) {
                return Optional.of(new ParamValidationError(parameterName, parameterValue, "should be equal or bigger than " + this.minValue));
            }
            if (parsedValue > this.maxValue) {
                return Optional.of(new ParamValidationError(parameterName, parameterValue, "should be equal or smaller than " + this.maxValue));
            }
            return Optional.empty();
        }
        catch (NumberFormatException e) {
            return Optional.of(new ParamValidationError(parameterName, parameterValue, "is not a parsable number"));
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.minValue, this.maxValue, this.defaultValue, this.parameterType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NumericFieldType other = (NumericFieldType)obj;
        return Objects.equals(this.minValue, other.minValue) && Objects.equals(this.maxValue, other.maxValue) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals((Object)this.parameterType, (Object)other.parameterType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minValue", this.minValue).add("maxValue", this.maxValue).add("defaultValue", this.defaultValue).add("parameterType", (Object)this.parameterType).toString();
    }

    public static enum ParameterConfigType {
        INT,
        DOUBLE;

    }
}

