/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.mocks;

import com.feedzai.openml.data.Dataset;
import com.feedzai.openml.data.FeatureValues;
import com.feedzai.openml.data.Instance;
import com.feedzai.openml.data.PartitionedDataset;
import com.feedzai.openml.data.schema.AbstractValueSchema;
import com.feedzai.openml.data.schema.CategoricalValueSchema;
import com.feedzai.openml.data.schema.DatasetSchema;
import com.feedzai.openml.data.schema.FieldSchema;
import com.feedzai.openml.data.schema.NumericValueSchema;
import com.feedzai.openml.mocks.MockInstance;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MockDataset
implements Dataset {
    private final DatasetSchema schema;
    private final List<Instance> instances;

    public MockDataset(Set<String> targetValues, int fieldSize, int instanceSize, Random random) {
        this(MockDataset.generateDefaultSchema(targetValues, fieldSize), instanceSize, random);
    }

    public MockDataset(DatasetSchema schema, int instanceSize, Random random) {
        this.schema = schema;
        this.instances = this.generateInstances(instanceSize, random);
    }

    public MockDataset(DatasetSchema schema, List<Instance> instances) {
        this.schema = schema;
        this.instances = instances;
    }

    public DatasetSchema getSchema() {
        return this.schema;
    }

    public Instance instance(int index) {
        return this.instances.get(index);
    }

    public FeatureValues feature(int index) {
        return null;
    }

    public Iterator<Instance> getInstances() {
        return this.instances.iterator();
    }

    public Dataset filter(Predicate<Instance> predicate) {
        return null;
    }

    public <K> Map<K, Dataset> groupBy(Function<Instance, K> function) {
        return null;
    }

    public PartitionedDataset partition(final Predicate<Instance> predicate) {
        return new PartitionedDataset(){

            public Dataset getMatchedData() {
                return new MockDataset(MockDataset.this.schema, MockDataset.this.instances.stream().filter(predicate).collect(Collectors.toList()));
            }

            public Dataset getUnmatchedData() {
                return new MockDataset(MockDataset.this.schema, MockDataset.this.instances.stream().filter(predicate.negate()).collect(Collectors.toList()));
            }
        };
    }

    public Dataset empty() {
        return null;
    }

    public int getInstancesSize() {
        return this.instances.size();
    }

    private List<Instance> generateInstances(int instanceSize, Random random) {
        return IntStream.range(0, instanceSize).mapToObj(index -> new MockInstance(this.schema, random)).collect(Collectors.toList());
    }

    public static DatasetSchema generateDefaultSchema(Set<String> targetValues, int fieldSize) {
        ImmutableList.Builder fieldSchemasBuilder = new ImmutableList.Builder();
        FieldSchema targetVariable = new FieldSchema("target", 0, (AbstractValueSchema)new CategoricalValueSchema(false, targetValues));
        List predictiveFields = IntStream.range(0, fieldSize).mapToObj(index -> new FieldSchema(String.format("field%d", index), index + 1, (AbstractValueSchema)new NumericValueSchema(false))).collect(Collectors.toList());
        fieldSchemasBuilder.add((Object)targetVariable);
        fieldSchemasBuilder.addAll(predictiveFields);
        return new DatasetSchema(0, (List)fieldSchemasBuilder.build());
    }
}

