/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.mocks;

import com.feedzai.openml.data.Instance;
import com.feedzai.openml.data.schema.AbstractValueSchema;
import com.feedzai.openml.data.schema.DatasetSchema;
import com.feedzai.openml.data.schema.FieldSchema;
import com.feedzai.openml.data.schema.NumericValueSchema;
import com.feedzai.openml.data.schema.StringValueSchema;
import com.feedzai.openml.util.data.ClassificationDatasetSchemaUtil;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MockInstance
implements Instance,
Serializable {
    private static final double MAX_NUMERIC_MOCK_VALUE = 10.0;
    private static final double MIN_NUMERIC_MOCK_VALUE = -10.0;
    private static final int NUM_MOCK_STRING_RANDOM_BYTES = 32;
    private static final long serialVersionUID = -6261681440631914349L;
    private final List<Serializable> values;

    public MockInstance(DatasetSchema schema, Random random) {
        this.values = schema.getFieldSchemas().stream().map(FieldSchema::getValueSchema).map(this.generateRandomFieldValue(random)).collect(Collectors.toList());
    }

    public MockInstance(int numberFieldsSize, Random random) {
        this.values = IntStream.range(0, numberFieldsSize).mapToObj(index -> new NumericValueSchema(false)).map(this.generateRandomFieldValue(random)).collect(Collectors.toList());
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MockInstance other = (MockInstance)obj;
        return Objects.equals(this.values, other.values);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.values).toString();
    }

    private Function<AbstractValueSchema, Serializable> generateRandomFieldValue(Random random) {
        return valueSchema -> {
            if (valueSchema instanceof NumericValueSchema) {
                return Double.valueOf(-10.0 + 20.0 * random.nextDouble());
            }
            if (valueSchema instanceof StringValueSchema) {
                byte[] randomBytes = new byte[32];
                random.nextBytes(randomBytes);
                byte[] base64encodedBytes = Base64.getUrlEncoder().encode(randomBytes);
                return new String(base64encodedBytes);
            }
            int numClassValues = ClassificationDatasetSchemaUtil.getNumClassValues(valueSchema);
            return Double.valueOf(random.nextInt(numClassValues));
        };
    }

    public MockInstance(List<Serializable> values) {
        this.values = values;
    }

    public MockInstance(double[] values) {
        this.values = Arrays.stream(values).boxed().collect(Collectors.toList());
    }

    public double getValue(int index) {
        return (Double)this.values.get(index);
    }

    public String getStringValue(int index) {
        return (String)((Object)this.values.get(index));
    }
}

