/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.util.algorithm;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.feedzai.openml.provider.descriptor.MLAlgorithmDescriptor;
import com.feedzai.openml.provider.descriptor.MachineLearningAlgorithmType;
import com.feedzai.openml.provider.descriptor.ModelParameter;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
public interface MLAlgorithmEnum {
    public static final Logger logger = LoggerFactory.getLogger(MLAlgorithmEnum.class);

    public static MLAlgorithmDescriptor createDescriptor(String algorithmName, Set<ModelParameter> algorithmParameters, MachineLearningAlgorithmType algorithmType, String documentationLink) {
        Preconditions.checkNotNull((Object)documentationLink, (Object)"The documentation link should not be null");
        URL documentationUrl = null;
        try {
            documentationUrl = new URL(documentationLink);
        }
        catch (MalformedURLException e) {
            logger.warn(String.format("The documentation URL for the algorithm descriptor '%s' is malformed", algorithmName), (Throwable)e);
            throw new IllegalArgumentException(String.format("Supplied documentation link is not a valid URL: %s", e.getMessage()));
        }
        return new MLAlgorithmDescriptor(algorithmName, algorithmParameters, algorithmType, documentationUrl);
    }

    public MLAlgorithmDescriptor getAlgorithmDescriptor();

    default public String getName() {
        return this.getAlgorithmDescriptor().getAlgorithmName();
    }

    public static Set<MLAlgorithmDescriptor> getDescriptors(MLAlgorithmEnum[] values) {
        return Arrays.stream(values).map(MLAlgorithmEnum::getAlgorithmDescriptor).collect(Collectors.toSet());
    }

    public static <T extends MLAlgorithmEnum> Optional<T> getByName(T[] values, String name) {
        return Arrays.stream(values).filter(value -> value.getName().equals(name)).findFirst();
    }
}

