/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.util.data;

import com.feedzai.openml.data.schema.AbstractValueSchema;
import com.feedzai.openml.data.schema.CategoricalValueSchema;
import com.feedzai.openml.data.schema.DatasetSchema;
import com.feedzai.openml.data.schema.FieldSchema;
import java.util.Optional;
import java.util.function.Function;

public final class ClassificationDatasetSchemaUtil {
    private ClassificationDatasetSchemaUtil() {
    }

    public static Optional<Integer> getNumClassValues(DatasetSchema datasetSchema) {
        return datasetSchema.getTargetIndex().map(datasetSchema.getFieldSchemas()::get).map(FieldSchema::getValueSchema).map(ClassificationDatasetSchemaUtil::getNumClassValues);
    }

    public static int getNumClassValues(AbstractValueSchema targetValueSchema) {
        return ClassificationDatasetSchemaUtil.withCategoricalValueSchema(targetValueSchema, categoricalValueSchema -> categoricalValueSchema.getNominalValues().size()).orElseThrow(() -> new RuntimeException("The target variable is not a categorical value: " + targetValueSchema));
    }

    public static <T> Optional<T> withCategoricalValueSchema(AbstractValueSchema targetValueSchema, Function<CategoricalValueSchema, T> block) {
        if (targetValueSchema instanceof CategoricalValueSchema) {
            return Optional.of(block.apply((CategoricalValueSchema)targetValueSchema));
        }
        return Optional.empty();
    }
}

