/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.util.data.encoding;

import com.feedzai.openml.data.schema.AbstractValueSchema;
import com.feedzai.openml.data.schema.CategoricalValueSchema;
import com.feedzai.openml.data.schema.DatasetSchema;
import com.feedzai.openml.data.schema.FieldSchema;
import com.feedzai.openml.data.schema.NumericValueSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class EncodingHelper
implements Serializable {
    private static final long serialVersionUID = 8695157460825684874L;
    private static final Double DEFAULT_CATEGORICAL_VALUE = Double.NaN;
    private static final Double DEFAULT_NUMERIC_VALUE = Double.NaN;
    private static final Object DEFAULT_STRING_VALUE = null;
    private final List<SerializableEncoder> encoders;

    public EncodingHelper(DatasetSchema schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"The schema must not be null.");
        ImmutableList.Builder converters = ImmutableList.builder();
        for (FieldSchema fieldSchema : schema.getFieldSchemas()) {
            converters.add((Object)EncodingHelper.encoderForField(fieldSchema.getValueSchema()));
        }
        this.encoders = converters.build();
    }

    public static SerializableEncoder encoderForField(AbstractValueSchema abstractValueSchema) {
        if (abstractValueSchema instanceof NumericValueSchema) {
            SerializableEncoder function = value -> Double.valueOf(value.toString());
            return value -> (Double)EncodingHelper.handleNullOrFailed(value, function, DEFAULT_NUMERIC_VALUE);
        }
        if (abstractValueSchema instanceof CategoricalValueSchema) {
            CategoricalValueSchema asCategorical = (CategoricalValueSchema)abstractValueSchema;
            Map<String, Double> conversionMap = EncodingHelper.conversionMap(asCategorical, index -> (double)index);
            SerializableEncoder function = value -> conversionMap.getOrDefault(value.toString(), DEFAULT_CATEGORICAL_VALUE);
            return value -> (Double)EncodingHelper.handleNullOrFailed(value, function, DEFAULT_CATEGORICAL_VALUE);
        }
        SerializableEncoder function = s -> s;
        return value -> (String)EncodingHelper.handleNullOrFailed(value, function, DEFAULT_STRING_VALUE);
    }

    public static String decodeDoubleToCategory(double doubleValue, CategoricalValueSchema categoricalValueSchema) {
        int index = (int)doubleValue;
        return (String)Iterables.get((Iterable)categoricalValueSchema.getNominalValues(), (int)index);
    }

    public static Function<Serializable, Integer> classToIndexConverter(CategoricalValueSchema targetVariableSchema) {
        Map conversionMap = EncodingHelper.conversionMap(targetVariableSchema, Function.identity());
        return value -> (Integer)conversionMap.get(value.toString());
    }

    private static <T> Map<String, T> conversionMap(CategoricalValueSchema categoricalValueSchema, Function<Integer, T> indexToValue) {
        ImmutableList nominalValues = ImmutableList.copyOf((Collection)categoricalValueSchema.getNominalValues());
        return IntStream.range(0, nominalValues.size()).boxed().collect(Collectors.toMap(((List)nominalValues)::get, indexToValue));
    }

    public Serializable encode(Serializable value, int index) {
        return (Serializable)this.encoders.get(index).apply(value);
    }

    public int numberFields() {
        return this.encoders.size();
    }

    private static Object handleNullOrFailed(Serializable value, SerializableEncoder function, Object coalescedValue) {
        try {
            return value == null ? coalescedValue : function.apply(value);
        }
        catch (Exception e) {
            return coalescedValue;
        }
    }

    public static interface SerializableEncoder
    extends Serializable,
    Function<Serializable, Serializable> {
    }
}

