/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.util.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.feedzai.openml.data.schema.AbstractValueSchema;
import com.feedzai.openml.data.schema.CategoricalValueSchema;
import com.feedzai.openml.data.schema.NumericValueSchema;
import com.feedzai.openml.data.schema.StringValueSchema;
import java.io.IOException;
import java.util.Set;
import java.util.SortedSet;

public class AbstractValueSchemaDeserializer
extends StdDeserializer<AbstractValueSchema> {
    public static final String ALLOW_MISSING = "allowMissing";
    public static final String VALUE_TYPE = "@type";
    public static final String NUMERIC_TYPE = "numeric";
    public static final String STRING_TYPE = "string";
    public static final String CATEGORICAL_TYPE = "categorical";
    public static final String NOMINAL_VALUES = "nominalValues";

    public AbstractValueSchemaDeserializer() {
        this(null);
    }

    public AbstractValueSchemaDeserializer(Class<?> vc) {
        super(vc);
    }

    public AbstractValueSchema deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode treeNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String fieldType = treeNode.get(VALUE_TYPE).textValue();
        boolean allowMissing = treeNode.get(ALLOW_MISSING).booleanValue();
        if (CATEGORICAL_TYPE.equals(fieldType)) {
            JsonNode fieldNode = treeNode.get(NOMINAL_VALUES);
            SortedSet nominalValues = (SortedSet)jsonParser.getCodec().readValue(fieldNode.traverse(jsonParser.getCodec()), (TypeReference)new TypeReference<SortedSet<String>>(){});
            return new CategoricalValueSchema(allowMissing, (Set)nominalValues);
        }
        if (NUMERIC_TYPE.equals(fieldType)) {
            return new NumericValueSchema(allowMissing);
        }
        if (STRING_TYPE.equals(fieldType)) {
            return new StringValueSchema(allowMissing);
        }
        throw new UnsupportedOperationException(String.format("A unknown field type [%s] was found.", fieldType));
    }
}

